/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.scalar;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.expression.multi.builtin.helper.CastFunctionHelper;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public class CastFunctionTransformer
extends UnaryTransformer {
    private final TSDataType targetDataType;

    public CastFunctionTransformer(LayerPointReader layerPointReader, TSDataType targetDataType) {
        super(layerPointReader);
        this.targetDataType = targetDataType;
    }

    @Override
    public TSDataType getDataType() {
        return this.targetDataType;
    }

    @Override
    protected void transformAndCache() throws QueryProcessException, IOException {
        switch (this.layerPointReaderDataType) {
            case INT32: {
                this.cast(this.layerPointReader.currentInt());
                return;
            }
            case INT64: {
                this.cast(this.layerPointReader.currentLong());
                return;
            }
            case FLOAT: {
                this.cast(this.layerPointReader.currentFloat());
                return;
            }
            case DOUBLE: {
                this.cast(this.layerPointReader.currentDouble());
                return;
            }
            case BOOLEAN: {
                this.cast(this.layerPointReader.currentBoolean());
                return;
            }
            case TEXT: {
                this.cast(this.layerPointReader.currentBinary());
                return;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported source dataType: %s", this.layerPointReaderDataType));
    }

    private void cast(int value) {
        switch (this.targetDataType) {
            case INT32: {
                this.cachedInt = value;
                return;
            }
            case INT64: {
                this.cachedLong = value;
                return;
            }
            case FLOAT: {
                this.cachedFloat = value;
                return;
            }
            case DOUBLE: {
                this.cachedDouble = value;
                return;
            }
            case BOOLEAN: {
                this.cachedBoolean = value != 0;
                return;
            }
            case TEXT: {
                this.cachedBinary = Binary.valueOf((String)String.valueOf(value));
                return;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.layerPointReaderDataType));
    }

    private void cast(long value) {
        switch (this.targetDataType) {
            case INT32: {
                this.cachedInt = CastFunctionHelper.castLongToInt(value);
                return;
            }
            case INT64: {
                this.cachedLong = value;
                return;
            }
            case FLOAT: {
                this.cachedFloat = value;
                return;
            }
            case DOUBLE: {
                this.cachedDouble = value;
                return;
            }
            case BOOLEAN: {
                this.cachedBoolean = value != 0L;
                return;
            }
            case TEXT: {
                this.cachedBinary = Binary.valueOf((String)String.valueOf(value));
                return;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.layerPointReaderDataType));
    }

    private void cast(float value) {
        switch (this.targetDataType) {
            case INT32: {
                this.cachedInt = CastFunctionHelper.castFloatToInt(value);
                return;
            }
            case INT64: {
                this.cachedLong = CastFunctionHelper.castFloatToLong(value);
                return;
            }
            case FLOAT: {
                this.cachedFloat = value;
                return;
            }
            case DOUBLE: {
                this.cachedDouble = value;
                return;
            }
            case BOOLEAN: {
                this.cachedBoolean = value != 0.0f;
                return;
            }
            case TEXT: {
                this.cachedBinary = Binary.valueOf((String)String.valueOf(value));
                return;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.layerPointReaderDataType));
    }

    private void cast(double value) {
        switch (this.targetDataType) {
            case INT32: {
                this.cachedInt = CastFunctionHelper.castDoubleToInt(value);
                return;
            }
            case INT64: {
                this.cachedLong = CastFunctionHelper.castDoubleToLong(value);
                return;
            }
            case FLOAT: {
                this.cachedFloat = CastFunctionHelper.castDoubleToFloat(value);
                return;
            }
            case DOUBLE: {
                this.cachedDouble = value;
                return;
            }
            case BOOLEAN: {
                this.cachedBoolean = value != 0.0;
                return;
            }
            case TEXT: {
                this.cachedBinary = Binary.valueOf((String)String.valueOf(value));
                return;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.layerPointReaderDataType));
    }

    private void cast(boolean value) {
        switch (this.targetDataType) {
            case INT32: {
                this.cachedInt = value ? 1 : 0;
                return;
            }
            case INT64: {
                this.cachedLong = value ? 1L : 0L;
                return;
            }
            case FLOAT: {
                this.cachedFloat = value ? 1.0f : 0.0f;
                return;
            }
            case DOUBLE: {
                this.cachedDouble = value ? 1.0 : 0.0;
                return;
            }
            case BOOLEAN: {
                this.cachedBoolean = value;
                return;
            }
            case TEXT: {
                this.cachedBinary = Binary.valueOf((String)String.valueOf(value));
                return;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.layerPointReaderDataType));
    }

    private void cast(Binary value) {
        String stringValue = value.getStringValue();
        switch (this.targetDataType) {
            case INT32: {
                this.cachedInt = Integer.parseInt(stringValue);
                return;
            }
            case INT64: {
                this.cachedLong = Long.parseLong(stringValue);
                return;
            }
            case FLOAT: {
                this.cachedFloat = CastFunctionHelper.castTextToFloat(stringValue);
                return;
            }
            case DOUBLE: {
                this.cachedDouble = CastFunctionHelper.castTextToDouble(stringValue);
                return;
            }
            case BOOLEAN: {
                this.cachedBoolean = CastFunctionHelper.castTextToBoolean(stringValue);
                return;
            }
            case TEXT: {
                this.cachedBinary = Binary.valueOf((String)String.valueOf(value));
                return;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.layerPointReaderDataType));
    }
}

