/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.sys;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.statement.IConfigStatement;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;

public class FlushStatement
extends Statement
implements IConfigStatement {
    private List<PartialPath> storageGroups;
    private Boolean isSeq;
    private boolean onCluster;

    public FlushStatement(StatementType flushType) {
        this.statementType = flushType;
    }

    public List<PartialPath> getStorageGroups() {
        return this.storageGroups;
    }

    public void setStorageGroups(List<PartialPath> storageGroups) {
        this.storageGroups = storageGroups;
    }

    public Boolean isSeq() {
        return this.isSeq;
    }

    public void setSeq(Boolean seq) {
        this.isSeq = seq;
    }

    public boolean isOnCluster() {
        return this.onCluster;
    }

    public void setOnCluster(boolean onCluster) {
        this.onCluster = onCluster;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    public List<PartialPath> getPaths() {
        if (this.storageGroups == null) {
            return Collections.emptyList();
        }
        return this.storageGroups;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitFlush(this, context);
    }
}

