/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.component;

import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.statement.StatementNode;

public class ResultColumn
extends StatementNode {
    private final Expression expression;
    private final String alias;
    private final ColumnType columnType;

    public ResultColumn(Expression expression, String alias, ColumnType columnType) {
        this.expression = expression;
        this.alias = alias;
        this.columnType = columnType;
    }

    public ResultColumn(Expression expression, ColumnType columnType) {
        this.expression = expression;
        this.columnType = columnType;
        this.alias = null;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public String getAlias() {
        return this.alias;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public String toString() {
        return "ResultColumn{expression=" + this.expression.getExpressionString() + ", alias='" + this.alias + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultColumn that = (ResultColumn)o;
        return Objects.equals(this.expression, that.expression) && Objects.equals(this.alias, that.alias);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.alias);
    }

    public static enum ColumnType {
        RAW,
        AGGREGATION,
        CONSTANT;

    }
}

