/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.distribution;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.execution.exchange.sink.DownStreamChannelLocation;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.optimization.LimitOffsetPushDown;
import org.apache.iotdb.db.mpp.plan.optimization.PlanOptimizer;
import org.apache.iotdb.db.mpp.plan.planner.IFragmentParallelPlaner;
import org.apache.iotdb.db.mpp.plan.planner.distribution.DistributionPlanContext;
import org.apache.iotdb.db.mpp.plan.planner.distribution.ExchangeNodeAdder;
import org.apache.iotdb.db.mpp.plan.planner.distribution.NodeGroupContext;
import org.apache.iotdb.db.mpp.plan.planner.distribution.SimpleFragmentParallelPlanner;
import org.apache.iotdb.db.mpp.plan.planner.distribution.SourceRewriter;
import org.apache.iotdb.db.mpp.plan.planner.distribution.WriteFragmentParallelPlanner;
import org.apache.iotdb.db.mpp.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.mpp.plan.planner.plan.SubPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.IdentitySinkNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.MultiChildrenSinkNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.ShuffleSinkNode;
import org.apache.iotdb.db.mpp.plan.statement.component.OrderByComponent;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;

public class DistributionPlanner {
    private Analysis analysis;
    private MPPQueryContext context;
    private LogicalQueryPlan logicalPlan;
    private final List<PlanOptimizer> optimizers;
    private int planFragmentIndex = 0;

    public DistributionPlanner(Analysis analysis, LogicalQueryPlan logicalPlan) {
        this.analysis = analysis;
        this.logicalPlan = logicalPlan;
        this.context = logicalPlan.getContext();
        this.optimizers = Collections.singletonList(new LimitOffsetPushDown());
    }

    public PlanNode rewriteSource() {
        SourceRewriter rewriter = new SourceRewriter(this.analysis);
        List<PlanNode> planNodeList = rewriter.visit(this.logicalPlan.getRootNode(), new DistributionPlanContext(this.context));
        if (planNodeList.size() != 1) {
            throw new IllegalStateException("root node must return only one");
        }
        return planNodeList.get(0);
    }

    public PlanNode addExchangeNode(PlanNode root) {
        ExchangeNodeAdder adder = new ExchangeNodeAdder(this.analysis);
        NodeGroupContext nodeGroupContext = new NodeGroupContext(this.context, this.analysis.getStatement() instanceof QueryStatement && ((QueryStatement)this.analysis.getStatement()).isAlignByDevice(), root);
        PlanNode newRoot = adder.visit(root, nodeGroupContext);
        this.adjustUpStream(newRoot, nodeGroupContext);
        return newRoot;
    }

    private void adjustUpStream(PlanNode root, NodeGroupContext context) {
        if (!context.hasExchangeNode) {
            return;
        }
        if (this.analysis.isVirtualSource()) {
            this.adjustUpStreamHelper(root, context);
            return;
        }
        boolean needShuffleSinkNode = this.analysis.getStatement() instanceof QueryStatement && this.needShuffleSinkNode((QueryStatement)this.analysis.getStatement(), context);
        this.adjustUpStreamHelper(root, new HashMap<TRegionReplicaSet, MultiChildrenSinkNode>(), needShuffleSinkNode, context);
    }

    private void adjustUpStreamHelper(PlanNode root, NodeGroupContext context) {
        for (PlanNode child : root.getChildren()) {
            this.adjustUpStreamHelper(child, context);
            if (!(child instanceof ExchangeNode)) continue;
            ExchangeNode exchangeNode = (ExchangeNode)child;
            IdentitySinkNode newChild = new IdentitySinkNode(context.queryContext.getQueryId().genPlanNodeId());
            newChild.addChild(exchangeNode.getChild());
            newChild.addDownStreamChannelLocation(new DownStreamChannelLocation(exchangeNode.getPlanNodeId().toString()));
            exchangeNode.setChild(newChild);
            exchangeNode.setIndexOfUpstreamSinkHandle(newChild.getCurrentLastIndex());
        }
    }

    private void adjustUpStreamHelper(PlanNode root, Map<TRegionReplicaSet, MultiChildrenSinkNode> memo, boolean needShuffleSinkNode, NodeGroupContext context) {
        for (PlanNode child : root.getChildren()) {
            this.adjustUpStreamHelper(child, memo, needShuffleSinkNode, context);
            if (!(child instanceof ExchangeNode)) continue;
            ExchangeNode exchangeNode = (ExchangeNode)child;
            TRegionReplicaSet regionOfChild = context.getNodeDistribution((PlanNodeId)exchangeNode.getChild().getPlanNodeId()).region;
            MultiChildrenSinkNode newChild = memo.computeIfAbsent(regionOfChild, tRegionReplicaSet -> needShuffleSinkNode ? new ShuffleSinkNode(context.queryContext.getQueryId().genPlanNodeId()) : new IdentitySinkNode(context.queryContext.getQueryId().genPlanNodeId()));
            newChild.addChild(exchangeNode.getChild());
            newChild.addDownStreamChannelLocation(new DownStreamChannelLocation(exchangeNode.getPlanNodeId().toString()));
            exchangeNode.setChild(newChild);
            exchangeNode.setIndexOfUpstreamSinkHandle(newChild.getCurrentLastIndex());
        }
    }

    private boolean needShuffleSinkNode(QueryStatement queryStatement, NodeGroupContext nodeGroupContext) {
        OrderByComponent orderByComponent = queryStatement.getOrderByComponent();
        return nodeGroupContext.isAlignByDevice() && orderByComponent != null && !orderByComponent.getSortItemList().isEmpty() && orderByComponent.isBasedOnTime() && !queryStatement.hasOrderByExpression();
    }

    public PlanNode optimize(PlanNode rootWithExchange) {
        if (this.analysis.getStatement() != null && this.analysis.getStatement().isQuery()) {
            for (PlanOptimizer optimizer : this.optimizers) {
                rootWithExchange = optimizer.optimize(rootWithExchange, this.analysis, this.context);
            }
        }
        return rootWithExchange;
    }

    public SubPlan splitFragment(PlanNode root) {
        FragmentBuilder fragmentBuilder = new FragmentBuilder(this.context);
        return fragmentBuilder.splitToSubPlan(root);
    }

    public DistributedQueryPlan planFragments() {
        PlanNode rootAfterRewrite = this.rewriteSource();
        PlanNode rootWithExchange = this.addExchangeNode(rootAfterRewrite);
        if (this.analysis.getStatement() != null && this.analysis.getStatement().isQuery()) {
            this.analysis.getRespDatasetHeader().setColumnToTsBlockIndexMap(rootWithExchange.getOutputColumnNames());
        }
        PlanNode optimizedRootWithExchange = this.optimize(rootWithExchange);
        SubPlan subPlan = this.splitFragment(optimizedRootWithExchange);
        subPlan.getPlanFragment().setRoot(true);
        List<FragmentInstance> fragmentInstances = this.planFragmentInstances(subPlan);
        if (this.context.getQueryType() == QueryType.READ) {
            this.SetSinkForRootInstance(subPlan, fragmentInstances);
        }
        return new DistributedQueryPlan(this.logicalPlan.getContext(), subPlan, subPlan.getPlanFragmentList(), fragmentInstances);
    }

    public List<FragmentInstance> planFragmentInstances(SubPlan subPlan) {
        IFragmentParallelPlaner parallelPlaner = this.context.getQueryType() == QueryType.READ ? new SimpleFragmentParallelPlanner(subPlan, this.analysis, this.context) : new WriteFragmentParallelPlanner(subPlan, this.analysis, this.context);
        return parallelPlaner.parallelPlan();
    }

    public void SetSinkForRootInstance(SubPlan subPlan, List<FragmentInstance> instances) {
        FragmentInstance rootInstance = null;
        for (FragmentInstance instance : instances) {
            if (!instance.getFragment().getId().equals(subPlan.getPlanFragment().getId())) continue;
            rootInstance = instance;
            break;
        }
        if (rootInstance == null) {
            return;
        }
        IdentitySinkNode sinkNode = new IdentitySinkNode(this.context.getQueryId().genPlanNodeId(), Collections.singletonList(rootInstance.getFragment().getPlanNodeTree()), Collections.singletonList(new DownStreamChannelLocation(this.context.getLocalDataBlockEndpoint(), this.context.getResultNodeContext().getVirtualFragmentInstanceId().toThrift(), this.context.getResultNodeContext().getVirtualResultNodeId().getId())));
        this.context.getResultNodeContext().setUpStream(rootInstance.getHostDataNode().mPPDataExchangeEndPoint, rootInstance.getId(), sinkNode.getPlanNodeId());
        rootInstance.getFragment().setPlanNodeTree(sinkNode);
    }

    private PlanFragmentId getNextFragmentId() {
        return this.logicalPlan.getContext().getQueryId().genPlanFragmentId();
    }

    private class FragmentBuilder {
        private MPPQueryContext context;

        public FragmentBuilder(MPPQueryContext context) {
            this.context = context;
        }

        public SubPlan splitToSubPlan(PlanNode root) {
            SubPlan rootSubPlan = this.createSubPlan(root);
            HashSet<PlanNodeId> visitedSinkNode = new HashSet<PlanNodeId>();
            this.splitToSubPlan(root, rootSubPlan, visitedSinkNode);
            return rootSubPlan;
        }

        private void splitToSubPlan(PlanNode root, SubPlan subPlan, Set<PlanNodeId> visitedSinkNode) {
            if (root instanceof WritePlanNode) {
                return;
            }
            if (root instanceof ExchangeNode) {
                ExchangeNode exchangeNode = (ExchangeNode)root;
                Validate.isTrue((boolean)(exchangeNode.getChild() instanceof MultiChildrenSinkNode), (String)"child of ExchangeNode must be MultiChildrenSinkNode", (Object[])new Object[0]);
                MultiChildrenSinkNode sinkNode = (MultiChildrenSinkNode)exchangeNode.getChild();
                exchangeNode.cleanChildren();
                if (!visitedSinkNode.contains(sinkNode.getPlanNodeId())) {
                    visitedSinkNode.add(sinkNode.getPlanNodeId());
                    SubPlan childSubPlan = this.createSubPlan(sinkNode);
                    this.splitToSubPlan(sinkNode, childSubPlan, visitedSinkNode);
                    subPlan.addChild(childSubPlan);
                }
                return;
            }
            for (PlanNode child : root.getChildren()) {
                this.splitToSubPlan(child, subPlan, visitedSinkNode);
            }
        }

        private SubPlan createSubPlan(PlanNode root) {
            PlanFragment fragment = new PlanFragment(DistributionPlanner.this.getNextFragmentId(), root);
            return new SubPlan(fragment);
        }
    }
}

