/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.udf.builtin.BuiltinAggregationFunction;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.TransformToViewExpressionVisitor;
import org.apache.iotdb.db.mpp.plan.planner.LogicalPlanBuilder;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.load.LoadTsFileNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.ActivateTemplateNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.BatchActivateTemplateNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.InternalBatchActivateTemplateNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.InternalCreateMultiTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.InternalCreateTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.MeasurementGroup;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.view.CreateLogicalViewNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.statement.StatementNode;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.InternalBatchActivateTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.InternalCreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.SchemaFetchStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountDevicesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountLevelTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowChildNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowChildPathsStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowDevicesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.BatchActivateTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowPathsUsingTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.view.CreateLogicalViewStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.view.ShowLogicalViewStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.ShowQueriesStatement;
import org.apache.iotdb.tsfile.utils.Pair;

public class LogicalPlanVisitor
extends StatementVisitor<PlanNode, MPPQueryContext> {
    private final Analysis analysis;

    public LogicalPlanVisitor(Analysis analysis) {
        this.analysis = analysis;
    }

    @Override
    public PlanNode visitNode(StatementNode node, MPPQueryContext context) {
        throw new UnsupportedOperationException("Unsupported statement type: " + node.getClass().getName());
    }

    @Override
    public PlanNode visitQuery(QueryStatement queryStatement, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        if (queryStatement.isLastQuery()) {
            planBuilder = planBuilder.planLast(this.analysis.getSourceExpressions(), this.analysis.getGlobalTimeFilter(), this.analysis.getTimeseriesOrderingForLastQuery()).planOffset(queryStatement.getRowOffset()).planLimit(queryStatement.getRowLimit());
            if (queryStatement.hasOrderBy() && !queryStatement.onlyOrderByTimeseries()) {
                planBuilder = planBuilder.planOrderBy(queryStatement.getSortItemList());
            }
            return planBuilder.getRoot();
        }
        if (queryStatement.isAlignByDevice()) {
            TreeMap<String, PlanNode> deviceToSubPlanMap = queryStatement.getResultDeviceOrder() == Ordering.ASC ? new TreeMap<String, PlanNode>() : new TreeMap(Collections.reverseOrder());
            for (String deviceName : this.analysis.getDeviceToSourceExpressions().keySet()) {
                LogicalPlanBuilder subPlanBuilder = new LogicalPlanBuilder(this.analysis, context);
                subPlanBuilder = subPlanBuilder.withNewRoot(this.visitQueryBody(queryStatement, this.analysis.getDeviceToSourceExpressions().get(deviceName), this.analysis.getDeviceToSourceTransformExpressions().get(deviceName), this.analysis.getDeviceToWhereExpression() != null ? this.analysis.getDeviceToWhereExpression().get(deviceName) : null, this.analysis.getDeviceToAggregationExpressions().get(deviceName), this.analysis.getDeviceToGroupByExpression() != null ? this.analysis.getDeviceToGroupByExpression().get(deviceName) : null, this.analysis.getDeviceViewInputIndexesMap().get(deviceName), context));
                if (queryStatement.needPushDownSort()) {
                    subPlanBuilder = subPlanBuilder.planOrderBy(this.analysis.getDeviceToOrderByExpressions().get(deviceName), this.analysis.getDeviceToSortItems().get(deviceName));
                }
                deviceToSubPlanMap.put(deviceName, subPlanBuilder.getRoot());
            }
            planBuilder = planBuilder.planDeviceView(deviceToSubPlanMap, this.analysis.getDeviceViewOutputExpressions(), this.analysis.getDeviceViewInputIndexesMap(), this.analysis.getSelectExpressions(), queryStatement);
        } else {
            planBuilder = planBuilder.withNewRoot(this.visitQueryBody(queryStatement, this.analysis.getSourceExpressions(), this.analysis.getSourceTransformExpressions(), this.analysis.getWhereExpression(), this.analysis.getAggregationExpressions(), this.analysis.getGroupByExpression(), null, context));
        }
        if (queryStatement.isAggregationQuery()) {
            planBuilder = planBuilder.planHavingAndTransform(this.analysis.getHavingExpression(), this.analysis.getSelectExpressions(), this.analysis.getOrderByExpressions(), queryStatement.isGroupByTime(), queryStatement.getSelectComponent().getZoneId(), queryStatement.getResultTimeOrder());
        }
        if (!queryStatement.needPushDownSort()) {
            planBuilder = planBuilder.planOrderBy(queryStatement, this.analysis.getOrderByExpressions(), this.analysis.getSelectExpressions());
        }
        planBuilder = planBuilder.planFill(this.analysis.getFillDescriptor(), queryStatement.getResultTimeOrder()).planOffset(queryStatement.getRowOffset()).planLimit(queryStatement.getRowLimit());
        planBuilder = queryStatement.isAlignByDevice() ? planBuilder.planDeviceViewInto(this.analysis.getDeviceViewIntoPathDescriptor()) : planBuilder.planInto(this.analysis.getIntoPathDescriptor());
        return planBuilder.getRoot();
    }

    public PlanNode visitQueryBody(QueryStatement queryStatement, Set<Expression> sourceExpressions, Set<Expression> sourceTransformExpressions, Expression whereExpression, Set<Expression> aggregationExpressions, Expression groupByExpression, List<Integer> deviceViewInputIndexes, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        if (aggregationExpressions == null) {
            planBuilder = planBuilder.planRawDataSource(sourceExpressions, queryStatement.getResultTimeOrder(), this.analysis.getGlobalTimeFilter()).planWhereAndSourceTransform(whereExpression, sourceTransformExpressions, queryStatement.isGroupByTime(), queryStatement.getSelectComponent().getZoneId(), queryStatement.getResultTimeOrder());
        } else {
            boolean isRawDataSource;
            boolean bl = isRawDataSource = this.analysis.hasValueFilter() || this.analysis.hasGroupByParameter() || this.needTransform(sourceTransformExpressions) || this.cannotUseStatistics(aggregationExpressions);
            if (isRawDataSource) {
                planBuilder = planBuilder.planRawDataSource(sourceExpressions, queryStatement.getResultTimeOrder(), this.analysis.getGlobalTimeFilter()).planWhereAndSourceTransform(whereExpression, sourceTransformExpressions, queryStatement.isGroupByTime(), queryStatement.getSelectComponent().getZoneId(), queryStatement.getResultTimeOrder());
                boolean outputPartial = queryStatement.isGroupByLevel() || queryStatement.isGroupByTime() && this.analysis.getGroupByTimeParameter().hasOverlap();
                AggregationStep curStep = outputPartial ? AggregationStep.PARTIAL : AggregationStep.SINGLE;
                planBuilder = planBuilder.planAggregation(aggregationExpressions, groupByExpression, this.analysis.getGroupByTimeParameter(), this.analysis.getGroupByParameter(), queryStatement.isOutputEndTime(), curStep, queryStatement.getResultTimeOrder());
                if (queryStatement.isGroupByTime() && this.analysis.getGroupByTimeParameter().hasOverlap()) {
                    curStep = queryStatement.isGroupByLevel() ? AggregationStep.INTERMEDIATE : AggregationStep.FINAL;
                    planBuilder = planBuilder.planSlidingWindowAggregation(aggregationExpressions, this.analysis.getGroupByTimeParameter(), curStep, queryStatement.getResultTimeOrder());
                }
                if (queryStatement.isGroupByLevel()) {
                    planBuilder = planBuilder.planGroupByLevel(this.analysis.getCrossGroupByExpressions(), this.analysis.getGroupByTimeParameter(), queryStatement.getResultTimeOrder());
                }
            } else {
                AggregationStep curStep = this.analysis.getCrossGroupByExpressions() != null || this.analysis.getGroupByTimeParameter() != null && this.analysis.getGroupByTimeParameter().hasOverlap() ? AggregationStep.PARTIAL : AggregationStep.SINGLE;
                planBuilder = deviceViewInputIndexes == null ? planBuilder.planAggregationSource(curStep, queryStatement.getResultTimeOrder(), this.analysis.getGlobalTimeFilter(), this.analysis.getGroupByTimeParameter(), aggregationExpressions, sourceTransformExpressions, this.analysis.getCrossGroupByExpressions(), this.analysis.getTagKeys(), this.analysis.getTagValuesToGroupedTimeseriesOperands()) : planBuilder.planAggregationSourceWithIndexAdjust(curStep, queryStatement.getResultTimeOrder(), this.analysis.getGlobalTimeFilter(), this.analysis.getGroupByTimeParameter(), aggregationExpressions, sourceTransformExpressions, this.analysis.getCrossGroupByExpressions(), deviceViewInputIndexes);
            }
        }
        return planBuilder.getRoot();
    }

    private boolean needTransform(Set<Expression> expressions) {
        for (Expression expression : expressions) {
            if (!ExpressionAnalyzer.checkIsNeedTransform(expression)) continue;
            return true;
        }
        return false;
    }

    private boolean cannotUseStatistics(Set<Expression> expressions) {
        for (Expression expression : expressions) {
            Validate.isTrue((boolean)(expression instanceof FunctionExpression), (String)String.format("Invalid Aggregation Expression: %s", expression.getExpressionString()), (Object[])new Object[0]);
            if (BuiltinAggregationFunction.canUseStatistics((String)((FunctionExpression)expression).getFunctionName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public PlanNode visitCreateTimeseries(CreateTimeSeriesStatement createTimeSeriesStatement, MPPQueryContext context) {
        return new CreateTimeSeriesNode(context.getQueryId().genPlanNodeId(), createTimeSeriesStatement.getPath(), createTimeSeriesStatement.getDataType(), createTimeSeriesStatement.getEncoding(), createTimeSeriesStatement.getCompressor(), createTimeSeriesStatement.getProps(), createTimeSeriesStatement.getTags(), createTimeSeriesStatement.getAttributes(), createTimeSeriesStatement.getAlias());
    }

    @Override
    public PlanNode visitCreateAlignedTimeseries(CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement, MPPQueryContext context) {
        return new CreateAlignedTimeSeriesNode(context.getQueryId().genPlanNodeId(), createAlignedTimeSeriesStatement.getDevicePath(), createAlignedTimeSeriesStatement.getMeasurements(), createAlignedTimeSeriesStatement.getDataTypes(), createAlignedTimeSeriesStatement.getEncodings(), createAlignedTimeSeriesStatement.getCompressors(), createAlignedTimeSeriesStatement.getAliasList(), createAlignedTimeSeriesStatement.getTagsList(), createAlignedTimeSeriesStatement.getAttributesList());
    }

    @Override
    public PlanNode visitInternalCreateTimeseries(InternalCreateTimeSeriesStatement internalCreateTimeSeriesStatement, MPPQueryContext context) {
        int size = internalCreateTimeSeriesStatement.getMeasurements().size();
        MeasurementGroup measurementGroup = new MeasurementGroup();
        for (int i = 0; i < size; ++i) {
            measurementGroup.addMeasurement(internalCreateTimeSeriesStatement.getMeasurements().get(i), internalCreateTimeSeriesStatement.getTsDataTypes().get(i), internalCreateTimeSeriesStatement.getEncodings().get(i), internalCreateTimeSeriesStatement.getCompressors().get(i));
        }
        return new InternalCreateTimeSeriesNode(context.getQueryId().genPlanNodeId(), internalCreateTimeSeriesStatement.getDevicePath(), measurementGroup, internalCreateTimeSeriesStatement.isAligned());
    }

    @Override
    public PlanNode visitCreateMultiTimeseries(CreateMultiTimeSeriesStatement createMultiTimeSeriesStatement, MPPQueryContext context) {
        return new CreateMultiTimeSeriesNode(context.getQueryId().genPlanNodeId(), createMultiTimeSeriesStatement.getPaths(), createMultiTimeSeriesStatement.getDataTypes(), createMultiTimeSeriesStatement.getEncodings(), createMultiTimeSeriesStatement.getCompressors(), createMultiTimeSeriesStatement.getPropsList(), createMultiTimeSeriesStatement.getAliasList(), createMultiTimeSeriesStatement.getTagsList(), createMultiTimeSeriesStatement.getAttributesList());
    }

    @Override
    public PlanNode visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesStatement internalCreateMultiTimeSeriesStatement, MPPQueryContext context) {
        return new InternalCreateMultiTimeSeriesNode(context.getQueryId().genPlanNodeId(), internalCreateMultiTimeSeriesStatement.getDeviceMap());
    }

    @Override
    public PlanNode visitAlterTimeseries(AlterTimeSeriesStatement alterTimeSeriesStatement, MPPQueryContext context) {
        return new AlterTimeSeriesNode(context.getQueryId().genPlanNodeId(), alterTimeSeriesStatement.getPath(), alterTimeSeriesStatement.getAlterType(), alterTimeSeriesStatement.getAlterMap(), alterTimeSeriesStatement.getAlias(), alterTimeSeriesStatement.getTagsMap(), alterTimeSeriesStatement.getAttributesMap(), alterTimeSeriesStatement.isAlterView());
    }

    @Override
    public PlanNode visitInsertTablet(InsertTabletStatement insertTabletStatement, MPPQueryContext context) {
        InsertTabletNode insertNode = new InsertTabletNode(context.getQueryId().genPlanNodeId(), insertTabletStatement.getDevicePath(), insertTabletStatement.isAligned(), insertTabletStatement.getMeasurements(), insertTabletStatement.getDataTypes(), insertTabletStatement.getMeasurementSchemas(), insertTabletStatement.getTimes(), insertTabletStatement.getBitMaps(), insertTabletStatement.getColumns(), insertTabletStatement.getRowCount());
        insertNode.setFailedMeasurementNumber(insertTabletStatement.getFailedMeasurementNumber());
        return insertNode;
    }

    @Override
    public PlanNode visitInsertRow(InsertRowStatement insertRowStatement, MPPQueryContext context) {
        InsertRowNode insertNode = new InsertRowNode(context.getQueryId().genPlanNodeId(), insertRowStatement.getDevicePath(), insertRowStatement.isAligned(), insertRowStatement.getMeasurements(), insertRowStatement.getDataTypes(), insertRowStatement.getMeasurementSchemas(), insertRowStatement.getTime(), insertRowStatement.getValues(), insertRowStatement.isNeedInferType());
        insertNode.setFailedMeasurementNumber(insertRowStatement.getFailedMeasurementNumber());
        return insertNode;
    }

    @Override
    public PlanNode visitLoadFile(LoadTsFileStatement loadTsFileStatement, MPPQueryContext context) {
        return new LoadTsFileNode(context.getQueryId().genPlanNodeId(), loadTsFileStatement.getResources());
    }

    @Override
    public PlanNode visitShowTimeSeries(ShowTimeSeriesStatement showTimeSeriesStatement, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        boolean canPushDownOffsetLimit = this.analysis.getSchemaPartitionInfo() != null && this.analysis.getSchemaPartitionInfo().getDistributionInfo().size() == 1 && !showTimeSeriesStatement.isOrderByHeat();
        long limit = showTimeSeriesStatement.getLimit();
        long offset = showTimeSeriesStatement.getOffset();
        if (showTimeSeriesStatement.isOrderByHeat()) {
            limit = 0L;
            offset = 0L;
        } else if (!canPushDownOffsetLimit) {
            limit = showTimeSeriesStatement.getLimit() + showTimeSeriesStatement.getOffset();
            offset = 0L;
        }
        planBuilder = planBuilder.planTimeSeriesSchemaSource(showTimeSeriesStatement.getPathPattern(), showTimeSeriesStatement.getSchemaFilter(), limit, offset, showTimeSeriesStatement.isOrderByHeat(), showTimeSeriesStatement.isPrefixPath(), this.analysis.getRelatedTemplateInfo()).planSchemaQueryMerge(showTimeSeriesStatement.isOrderByHeat());
        if (showTimeSeriesStatement.isOrderByHeat() && null != this.analysis.getDataPartitionInfo() && 0 != this.analysis.getDataPartitionInfo().getDataPartitionMap().size()) {
            PlanNode lastPlanNode = new LogicalPlanBuilder(this.analysis, context).planLast(this.analysis.getSourceExpressions(), this.analysis.getGlobalTimeFilter(), null).getRoot();
            planBuilder = planBuilder.planSchemaQueryOrderByHeat(lastPlanNode);
        }
        if (canPushDownOffsetLimit) {
            return planBuilder.getRoot();
        }
        return planBuilder.planOffset(showTimeSeriesStatement.getOffset()).planLimit(showTimeSeriesStatement.getLimit()).getRoot();
    }

    @Override
    public PlanNode visitShowDevices(ShowDevicesStatement showDevicesStatement, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        boolean canPushDownOffsetLimit = this.analysis.getSchemaPartitionInfo() != null && this.analysis.getSchemaPartitionInfo().getDistributionInfo().size() == 1;
        long limit = showDevicesStatement.getLimit();
        long offset = showDevicesStatement.getOffset();
        if (!canPushDownOffsetLimit) {
            limit = showDevicesStatement.getLimit() + showDevicesStatement.getOffset();
            offset = 0L;
        }
        planBuilder = planBuilder.planDeviceSchemaSource(showDevicesStatement.getPathPattern(), limit, offset, showDevicesStatement.isPrefixPath(), showDevicesStatement.hasSgCol(), showDevicesStatement.getSchemaFilter()).planSchemaQueryMerge(false);
        if (!canPushDownOffsetLimit) {
            return planBuilder.planOffset(showDevicesStatement.getOffset()).planLimit(showDevicesStatement.getLimit()).getRoot();
        }
        return planBuilder.getRoot();
    }

    @Override
    public PlanNode visitCountDevices(CountDevicesStatement countDevicesStatement, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        return planBuilder.planDevicesCountSource(countDevicesStatement.getPathPattern(), countDevicesStatement.isPrefixPath()).planCountMerge().getRoot();
    }

    @Override
    public PlanNode visitCountTimeSeries(CountTimeSeriesStatement countTimeSeriesStatement, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        return planBuilder.planTimeSeriesCountSource(countTimeSeriesStatement.getPathPattern(), countTimeSeriesStatement.isPrefixPath(), countTimeSeriesStatement.getSchemaFilter(), this.analysis.getRelatedTemplateInfo()).planCountMerge().getRoot();
    }

    @Override
    public PlanNode visitCountLevelTimeSeries(CountLevelTimeSeriesStatement countLevelTimeSeriesStatement, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        return planBuilder.planLevelTimeSeriesCountSource(countLevelTimeSeriesStatement.getPathPattern(), countLevelTimeSeriesStatement.isPrefixPath(), countLevelTimeSeriesStatement.getLevel(), countLevelTimeSeriesStatement.getSchemaFilter(), this.analysis.getRelatedTemplateInfo()).planCountMerge().getRoot();
    }

    @Override
    public PlanNode visitCountNodes(CountNodesStatement countStatement, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        return planBuilder.planNodePathsSchemaSource(countStatement.getPathPattern(), countStatement.getLevel()).planSchemaQueryMerge(false).planNodeManagementMemoryMerge(this.analysis.getMatchedNodes()).planNodePathsCount().getRoot();
    }

    @Override
    public PlanNode visitInsertRows(InsertRowsStatement insertRowsStatement, MPPQueryContext context) {
        InsertRowsNode insertRowsNode = new InsertRowsNode(context.getQueryId().genPlanNodeId());
        for (int i = 0; i < insertRowsStatement.getInsertRowStatementList().size(); ++i) {
            InsertRowStatement insertRowStatement = insertRowsStatement.getInsertRowStatementList().get(i);
            InsertRowNode insertRowNode = new InsertRowNode(insertRowsNode.getPlanNodeId(), insertRowStatement.getDevicePath(), insertRowStatement.isAligned(), insertRowStatement.getMeasurements(), insertRowStatement.getDataTypes(), insertRowStatement.getMeasurementSchemas(), insertRowStatement.getTime(), insertRowStatement.getValues(), insertRowStatement.isNeedInferType());
            insertRowNode.setFailedMeasurementNumber(insertRowStatement.getFailedMeasurementNumber());
            insertRowsNode.addOneInsertRowNode(insertRowNode, i);
        }
        return insertRowsNode;
    }

    @Override
    public PlanNode visitInsertMultiTablets(InsertMultiTabletsStatement insertMultiTabletsStatement, MPPQueryContext context) {
        InsertMultiTabletsNode insertMultiTabletsNode = new InsertMultiTabletsNode(context.getQueryId().genPlanNodeId());
        for (int i = 0; i < insertMultiTabletsStatement.getInsertTabletStatementList().size(); ++i) {
            InsertTabletStatement insertTabletStatement = insertMultiTabletsStatement.getInsertTabletStatementList().get(i);
            InsertTabletNode insertTabletNode = new InsertTabletNode(insertMultiTabletsNode.getPlanNodeId(), insertTabletStatement.getDevicePath(), insertTabletStatement.isAligned(), insertTabletStatement.getMeasurements(), insertTabletStatement.getDataTypes(), insertTabletStatement.getMeasurementSchemas(), insertTabletStatement.getTimes(), insertTabletStatement.getBitMaps(), insertTabletStatement.getColumns(), insertTabletStatement.getRowCount());
            insertTabletNode.setFailedMeasurementNumber(insertTabletStatement.getFailedMeasurementNumber());
            insertMultiTabletsNode.addInsertTabletNode(insertTabletNode, i);
        }
        return insertMultiTabletsNode;
    }

    @Override
    public PlanNode visitInsertRowsOfOneDevice(InsertRowsOfOneDeviceStatement insertRowsOfOneDeviceStatement, MPPQueryContext context) {
        InsertRowsOfOneDeviceNode insertRowsOfOneDeviceNode = new InsertRowsOfOneDeviceNode(context.getQueryId().genPlanNodeId());
        ArrayList<InsertRowNode> insertRowNodeList = new ArrayList<InsertRowNode>();
        ArrayList<Integer> insertRowNodeIndexList = new ArrayList<Integer>();
        for (int i = 0; i < insertRowsOfOneDeviceStatement.getInsertRowStatementList().size(); ++i) {
            InsertRowStatement insertRowStatement = insertRowsOfOneDeviceStatement.getInsertRowStatementList().get(i);
            InsertRowNode insertRowNode = new InsertRowNode(insertRowsOfOneDeviceNode.getPlanNodeId(), insertRowStatement.getDevicePath(), insertRowStatement.isAligned(), insertRowStatement.getMeasurements(), insertRowStatement.getDataTypes(), insertRowStatement.getMeasurementSchemas(), insertRowStatement.getTime(), insertRowStatement.getValues(), insertRowStatement.isNeedInferType());
            insertRowNode.setFailedMeasurementNumber(insertRowStatement.getFailedMeasurementNumber());
            insertRowNodeList.add(insertRowNode);
            insertRowNodeIndexList.add(i);
        }
        insertRowsOfOneDeviceNode.setInsertRowNodeList(insertRowNodeList);
        insertRowsOfOneDeviceNode.setInsertRowNodeIndexList(insertRowNodeIndexList);
        return insertRowsOfOneDeviceNode;
    }

    @Override
    public PlanNode visitSchemaFetch(SchemaFetchStatement schemaFetchStatement, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        ArrayList<String> storageGroupList = new ArrayList<String>(this.analysis.getSchemaPartitionInfo().getSchemaPartitionMap().keySet());
        return planBuilder.planSchemaFetchMerge(storageGroupList).planSchemaFetchSource(storageGroupList, schemaFetchStatement.getPatternTree(), schemaFetchStatement.getTemplateMap(), schemaFetchStatement.isWithTags()).getRoot();
    }

    @Override
    public PlanNode visitShowChildPaths(ShowChildPathsStatement showChildPathsStatement, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        return planBuilder.planNodePathsSchemaSource(showChildPathsStatement.getPartialPath(), -1).planSchemaQueryMerge(false).planNodeManagementMemoryMerge(this.analysis.getMatchedNodes()).getRoot();
    }

    @Override
    public PlanNode visitShowChildNodes(ShowChildNodesStatement showChildNodesStatement, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        return planBuilder.planNodePathsSchemaSource(showChildNodesStatement.getPartialPath(), -1).planSchemaQueryMerge(false).planNodeManagementMemoryMerge(this.analysis.getMatchedNodes()).planNodePathsConvert().getRoot();
    }

    @Override
    public PlanNode visitDeleteData(DeleteDataStatement deleteDataStatement, MPPQueryContext context) {
        return new DeleteDataNode(context.getQueryId().genPlanNodeId(), deleteDataStatement.getPathList(), deleteDataStatement.getDeleteStartTime(), deleteDataStatement.getDeleteEndTime());
    }

    @Override
    public PlanNode visitActivateTemplate(ActivateTemplateStatement activateTemplateStatement, MPPQueryContext context) {
        return new ActivateTemplateNode(context.getQueryId().genPlanNodeId(), activateTemplateStatement.getPath(), ((PartialPath)((List)this.analysis.getTemplateSetInfo().right).get(0)).getNodeLength() - 1, ((Template)this.analysis.getTemplateSetInfo().left).getId());
    }

    @Override
    public PlanNode visitBatchActivateTemplate(BatchActivateTemplateStatement batchActivateTemplateStatement, MPPQueryContext context) {
        HashMap<PartialPath, Pair<Integer, Integer>> templateActivationMap = new HashMap<PartialPath, Pair<Integer, Integer>>();
        for (Map.Entry<PartialPath, Pair<Template, PartialPath>> entry : this.analysis.getDeviceTemplateSetInfoMap().entrySet()) {
            templateActivationMap.put(entry.getKey(), (Pair<Integer, Integer>)new Pair((Object)((Template)entry.getValue().left).getId(), (Object)(((PartialPath)entry.getValue().right).getNodeLength() - 1)));
        }
        return new BatchActivateTemplateNode(context.getQueryId().genPlanNodeId(), templateActivationMap);
    }

    @Override
    public PlanNode visitInternalBatchActivateTemplate(InternalBatchActivateTemplateStatement internalBatchActivateTemplateStatement, MPPQueryContext context) {
        HashMap<PartialPath, Pair<Integer, Integer>> templateActivationMap = new HashMap<PartialPath, Pair<Integer, Integer>>();
        for (Map.Entry<PartialPath, Pair<Template, PartialPath>> entry : internalBatchActivateTemplateStatement.getDeviceMap().entrySet()) {
            templateActivationMap.put(entry.getKey(), (Pair<Integer, Integer>)new Pair((Object)((Template)entry.getValue().left).getId(), (Object)(((PartialPath)entry.getValue().right).getNodeLength() - 1)));
        }
        return new InternalBatchActivateTemplateNode(context.getQueryId().genPlanNodeId(), templateActivationMap);
    }

    @Override
    public PlanNode visitShowPathsUsingTemplate(ShowPathsUsingTemplateStatement showPathsUsingTemplateStatement, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        planBuilder = planBuilder.planPathsUsingTemplateSource(this.analysis.getSpecifiedTemplateRelatedPathPatternList(), ((Template)this.analysis.getTemplateSetInfo().left).getId()).planSchemaQueryMerge(false);
        return planBuilder.getRoot();
    }

    @Override
    public PlanNode visitShowQueries(ShowQueriesStatement showQueriesStatement, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        planBuilder = planBuilder.planShowQueries(this.analysis, showQueriesStatement).planOffset(showQueriesStatement.getRowOffset()).planLimit(showQueriesStatement.getRowLimit());
        return planBuilder.getRoot();
    }

    @Override
    public PlanNode visitCreateLogicalView(CreateLogicalViewStatement createLogicalViewStatement, MPPQueryContext context) {
        ArrayList<ViewExpression> viewExpressionList = new ArrayList<ViewExpression>();
        if (createLogicalViewStatement.getViewExpression() == null) {
            TransformToViewExpressionVisitor transformToViewExpressionVisitor = new TransformToViewExpressionVisitor();
            List<Expression> expressionList = createLogicalViewStatement.getSourceExpressionList();
            for (Expression expression : expressionList) {
                viewExpressionList.add(transformToViewExpressionVisitor.process(expression, null));
            }
        } else {
            viewExpressionList.add(createLogicalViewStatement.getViewExpression());
        }
        return new CreateLogicalViewNode(context.getQueryId().genPlanNodeId(), createLogicalViewStatement.getTargetPathList(), viewExpressionList);
    }

    @Override
    public PlanNode visitShowLogicalView(ShowLogicalViewStatement showLogicalViewStatement, MPPQueryContext context) {
        LogicalPlanBuilder planBuilder = new LogicalPlanBuilder(this.analysis, context);
        boolean canPushDownOffsetLimit = this.analysis.getSchemaPartitionInfo() != null && this.analysis.getSchemaPartitionInfo().getDistributionInfo().size() == 1;
        long limit = showLogicalViewStatement.getLimit();
        long offset = showLogicalViewStatement.getOffset();
        if (!canPushDownOffsetLimit) {
            limit = showLogicalViewStatement.getLimit() + showLogicalViewStatement.getOffset();
            offset = 0L;
        }
        planBuilder = planBuilder.planLogicalViewSchemaSource(showLogicalViewStatement.getPathPattern(), showLogicalViewStatement.getSchemaFilter(), limit, offset).planSchemaQueryMerge(false);
        if (canPushDownOffsetLimit) {
            return planBuilder.getRoot();
        }
        return planBuilder.planOffset(showLogicalViewStatement.getOffset()).planLimit(showLogicalViewStatement.getLimit()).getRoot();
    }
}

