/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.unary;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;

public class LogicNotExpression
extends UnaryExpression {
    public LogicNotExpression(Expression expression) {
        super(expression);
    }

    public LogicNotExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
    }

    @Override
    protected Expression constructExpression(Expression childExpression) {
        return new LogicNotExpression(childExpression);
    }

    @Override
    public String getExpressionStringInternal() {
        return this.expression instanceof FunctionExpression || this.expression instanceof LeafOperand ? "!" + this.expression.getExpressionString() : "!(" + this.expression.getExpressionString() + ")";
    }

    @Override
    public String getOutputSymbolInternal() {
        return this.expression instanceof FunctionExpression || this.expression instanceof ConstantOperand || this.expression instanceof TimeSeriesOperand ? "!" + this.expression.getOutputSymbol() : "!(" + this.expression.getOutputSymbol() + ")";
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.LOGIC_NOT;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLogicNotExpression(this, context);
    }
}

