/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.ternary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.ternary.TernaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class BetweenExpression
extends TernaryExpression {
    private final boolean isNotBetween;

    public boolean isNotBetween() {
        return this.isNotBetween;
    }

    public BetweenExpression(Expression firstExpression, Expression secondExpression, Expression thirdExpression, boolean isNotBetween) {
        super(firstExpression, secondExpression, thirdExpression);
        this.isNotBetween = isNotBetween;
    }

    public BetweenExpression(Expression firstExpression, Expression secondExpression, Expression thirdExpression) {
        super(firstExpression, secondExpression, thirdExpression);
        this.isNotBetween = false;
    }

    public BetweenExpression(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.isNotBetween = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }

    @Override
    protected String operator() {
        return "between";
    }

    @Override
    protected String getExpressionStringInternal() {
        return this.firstExpression.getExpressionString() + " BETWEEN " + this.secondExpression.getExpressionString() + " AND " + this.thirdExpression.getExpressionString();
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.BETWEEN;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isNotBetween, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.isNotBetween, (OutputStream)stream);
    }

    @Override
    public String getOutputSymbolInternal() {
        return this.firstExpression.getOutputSymbol() + " BETWEEN " + this.secondExpression.getOutputSymbol() + " AND " + this.thirdExpression.getOutputSymbol();
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitBetweenExpression(this, context);
    }
}

