/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.multi;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.udf.builtin.BuiltinAggregationFunction;
import org.apache.iotdb.commons.udf.builtin.BuiltinScalarFunction;
import org.apache.iotdb.db.mpp.common.NodeRef;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionType;
import org.apache.iotdb.db.mpp.plan.expression.multi.builtin.BuiltInScalarFunctionHelperFactory;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFInformationInferrer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;

public class FunctionExpression
extends Expression {
    private FunctionType functionType;
    private final String functionName;
    private final LinkedHashMap<String, String> functionAttributes;
    private List<Expression> expressions;
    private List<PartialPath> paths;
    private String parametersString;

    public FunctionExpression(String functionName) {
        this.functionName = functionName;
        this.functionAttributes = new LinkedHashMap();
        this.expressions = new ArrayList<Expression>();
    }

    public FunctionExpression(String functionName, LinkedHashMap<String, String> functionAttributes, List<Expression> expressions) {
        this.functionName = functionName;
        this.functionAttributes = functionAttributes;
        this.expressions = expressions;
    }

    public FunctionExpression(ByteBuffer byteBuffer) {
        this.functionName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.functionAttributes = ReadWriteIOUtils.readLinkedHashMap((ByteBuffer)byteBuffer);
        int expressionSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.expressions = new ArrayList<Expression>();
        for (int i = 0; i < expressionSize; ++i) {
            this.expressions.add(Expression.deserialize(byteBuffer));
        }
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionExpression(this, context);
    }

    private void initializeFunctionType() {
        String functionName = this.functionName.toLowerCase();
        this.functionType = BuiltinAggregationFunction.getNativeFunctionNames().contains(functionName) ? FunctionType.AGGREGATION_FUNCTION : (BuiltinScalarFunction.getNativeFunctionNames().contains(functionName) ? FunctionType.BUILT_IN_SCALAR_FUNCTION : FunctionType.UDF);
    }

    @Override
    public boolean isBuiltInAggregationFunctionExpression() {
        if (this.functionType == null) {
            this.initializeFunctionType();
        }
        return this.functionType == FunctionType.AGGREGATION_FUNCTION;
    }

    public Boolean isBuiltInScalarFunction() {
        if (this.functionType == null) {
            this.initializeFunctionType();
        }
        return this.functionType == FunctionType.BUILT_IN_SCALAR_FUNCTION;
    }

    @Override
    public boolean isConstantOperandInternal() {
        if (this.isConstantOperandCache == null) {
            this.isConstantOperandCache = true;
            for (Expression inputExpression : this.expressions) {
                if (inputExpression.isConstantOperand()) continue;
                this.isConstantOperandCache = false;
                break;
            }
        }
        return this.isConstantOperandCache;
    }

    public boolean isCountStar() {
        if (!this.isBuiltInAggregationFunctionExpression()) {
            return false;
        }
        return this.getPaths().size() == 1 && this.paths.get(0) != null && (this.paths.get(0).getTailNode().equals("*") || this.paths.get(0).getTailNode().equals("**")) && this.functionName.equals("count");
    }

    public void addAttribute(String key, String value) {
        this.functionAttributes.put(key, value);
    }

    public void addExpression(Expression expression) {
        this.expressions.add(expression);
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public LinkedHashMap<String, String> getFunctionAttributes() {
        return this.functionAttributes;
    }

    @Override
    public List<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public String getOutputSymbolInternal() {
        StringBuilder builder = new StringBuilder();
        if (!this.expressions.isEmpty()) {
            builder.append(this.expressions.get(0).getOutputSymbol());
            for (int i = 1; i < this.expressions.size(); ++i) {
                builder.append(", ").append(this.expressions.get(i).getOutputSymbol());
            }
        }
        if (!this.functionAttributes.isEmpty()) {
            if (BuiltinScalarFunction.contains((String)this.functionName)) {
                BuiltInScalarFunctionHelperFactory.createHelper(this.functionName).appendFunctionAttributes(!this.expressions.isEmpty(), builder, this.functionAttributes);
            } else {
                FunctionExpression.appendAttributes(!this.expressions.isEmpty(), builder, this.functionAttributes);
            }
        }
        return this.functionName + "(" + builder + ")";
    }

    @Override
    public void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
        String expressionString = this.getExpressionString();
        if (expressionName2Executor.containsKey(expressionString)) {
            return;
        }
        for (Expression expression : this.expressions) {
            expression.constructUdfExecutors(expressionName2Executor, zoneId);
        }
        expressionName2Executor.put(expressionString, new UDTFExecutor(this.functionName, zoneId));
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
        for (Expression expression : this.expressions) {
            expression.bindInputLayerColumnIndexWithExpression(inputLocations);
        }
        String digest = this.getExpressionString();
        if (inputLocations.containsKey(digest)) {
            this.inputColumnIndex = inputLocations.get(digest).get(0).getValueColumnIndex();
        }
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        for (Expression expression : this.expressions) {
            expression.updateStatisticsForMemoryAssigner(memoryAssigner);
        }
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public boolean isMappable(Map<NodeRef<Expression>, TSDataType> expressionTypes) {
        if (this.isBuiltInAggregationFunctionExpression() || this.isBuiltInScalarFunction().booleanValue()) {
            return true;
        }
        return new UDTFInformationInferrer(this.functionName).getAccessStrategy(this.expressions.stream().map(Expression::getExpressionString).collect(Collectors.toList()), this.expressions.stream().map(f -> (TSDataType)expressionTypes.get(NodeRef.of(f))).collect(Collectors.toList()), this.functionAttributes).getAccessStrategyType().equals((Object)AccessStrategy.AccessStrategyType.MAPPABLE_ROW_BY_ROW);
    }

    public List<PartialPath> getPaths() {
        if (this.paths == null) {
            this.paths = new ArrayList<PartialPath>();
            for (Expression expression : this.expressions) {
                this.paths.add(expression instanceof TimeSeriesOperand ? ((TimeSeriesOperand)expression).getPath() : null);
            }
        }
        return this.paths;
    }

    @Override
    public String getExpressionStringInternal() {
        return this.functionName + "(" + this.getParametersString() + ")";
    }

    private String getParametersString() {
        if (this.parametersString == null) {
            StringBuilder builder = new StringBuilder();
            if (!this.expressions.isEmpty()) {
                builder.append(this.expressions.get(0).getExpressionString());
                for (int i = 1; i < this.expressions.size(); ++i) {
                    builder.append(", ").append(this.expressions.get(i).getExpressionString());
                }
            }
            if (!this.functionAttributes.isEmpty()) {
                if (BuiltinScalarFunction.contains((String)this.functionName)) {
                    BuiltInScalarFunctionHelperFactory.createHelper(this.functionName).appendFunctionAttributes(!this.expressions.isEmpty(), builder, this.functionAttributes);
                } else {
                    FunctionExpression.appendAttributes(!this.expressions.isEmpty(), builder, this.functionAttributes);
                }
            }
            this.parametersString = builder.toString();
        }
        return this.parametersString;
    }

    public static void appendAttributes(boolean hasExpression, StringBuilder builder, Map<String, String> functionAttributes) {
        if (hasExpression) {
            builder.append(", ");
        }
        Iterator<Map.Entry<String, String>> iterator = functionAttributes.entrySet().iterator();
        Map.Entry<String, String> entry = iterator.next();
        builder.append("\"").append(entry.getKey()).append("\"=\"").append(entry.getValue()).append("\"");
        while (iterator.hasNext()) {
            entry = iterator.next();
            builder.append(", ").append("\"").append(entry.getKey()).append("\"=\"").append(entry.getValue()).append("\"");
        }
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.FUNCTION;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.functionName, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write(this.functionAttributes, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.expressions.size(), (ByteBuffer)byteBuffer);
        for (Expression expression : this.expressions) {
            Expression.serialize(expression, byteBuffer);
        }
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.functionName, (OutputStream)stream);
        ReadWriteIOUtils.write(this.functionAttributes, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.expressions.size(), (OutputStream)stream);
        for (Expression expression : this.expressions) {
            Expression.serialize(expression, stream);
        }
    }
}

