/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.metric;

import java.util.Objects;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class ChunkCacheMetrics
implements IMetricSet {
    private final ChunkCache chunkCache;

    public ChunkCacheMetrics(ChunkCache chunkCache) {
        this.chunkCache = chunkCache;
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.CACHE_HIT_RATE.toString(), MetricLevel.IMPORTANT, (Object)this.chunkCache, ChunkCache::getHitRate, new String[]{Tag.NAME.toString(), "chunk"});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.CACHE_HIT_RATE.toString(), new String[]{Tag.NAME.toString(), "chunk"});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkCacheMetrics that = (ChunkCacheMetrics)o;
        return Objects.equals(this.chunkCache, that.chunkCache);
    }

    public int hashCode() {
        return Objects.hash(this.chunkCache);
    }
}

