/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule.task;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.Duration;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.driver.DriverContext;
import org.apache.iotdb.db.mpp.execution.driver.IDriver;
import org.apache.iotdb.db.mpp.execution.exchange.sink.ISink;
import org.apache.iotdb.db.mpp.execution.schedule.ExecutionContext;
import org.apache.iotdb.db.mpp.execution.schedule.queue.ID;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IDIndexedAccessible;
import org.apache.iotdb.db.mpp.execution.schedule.queue.multilevelqueue.DriverTaskHandle;
import org.apache.iotdb.db.mpp.execution.schedule.queue.multilevelqueue.Priority;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTaskId;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTaskStatus;

public class DriverTask
implements IDIndexedAccessible {
    private final IDriver driver;
    private DriverTaskStatus status;
    private final long ddl;
    private final Lock lock;
    private long cpuWallNano;
    private String abortCause;
    private final AtomicReference<Priority> priority;
    private final DriverTaskHandle driverTaskHandle;
    private long lastEnterReadyQueueTime;
    private long lastEnterBlockQueueTime;
    private long estimatedMemorySize;

    public DriverTask() {
        this(new StubFragmentInstance(), 0L, null, null, 0L);
    }

    public DriverTask(IDriver driver, long timeoutMs, DriverTaskStatus status, DriverTaskHandle driverTaskHandle, long estimatedMemorySize) {
        this.driver = driver;
        this.setStatus(status);
        this.ddl = System.currentTimeMillis() + timeoutMs;
        this.lock = new ReentrantLock();
        this.driverTaskHandle = driverTaskHandle;
        this.priority = new AtomicReference<Priority>(new Priority(0, 0L));
        this.estimatedMemorySize = estimatedMemorySize;
    }

    @Override
    public DriverTaskId getDriverTaskId() {
        return this.driver.getDriverTaskId();
    }

    public long getEstimatedMemorySize() {
        return this.driver.getEstimatedMemorySize();
    }

    @Override
    public void setId(ID id) {
        this.driver.setDriverTaskId((DriverTaskId)id);
    }

    public DriverTaskStatus getStatus() {
        return this.status;
    }

    public boolean isEndState() {
        return this.status == DriverTaskStatus.ABORTED || this.status == DriverTaskStatus.FINISHED;
    }

    public IDriver getDriver() {
        return this.driver;
    }

    public void setStatus(DriverTaskStatus status) {
        this.status = status;
    }

    public void updateSchedulePriority(ExecutionContext context) {
        this.priority.set(this.driverTaskHandle.addScheduledTimeInNanos(context.getScheduledTimeInNanos()));
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public long getDDL() {
        return this.ddl;
    }

    public int hashCode() {
        return this.driver.getDriverTaskId().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof DriverTask && ((DriverTask)o).getDriverTaskId().equals(this.getDriverTaskId());
    }

    public String getAbortCause() {
        return this.abortCause;
    }

    public void setAbortCause(String abortCause) {
        this.abortCause = abortCause;
    }

    public SettableFuture<Void> getBlockedDependencyDriver() {
        return this.driver.getDriverContext().getDownstreamOperator().getBlockedDependencyDriver();
    }

    public Priority getPriority() {
        return this.priority.get();
    }

    public boolean updatePriority() {
        Priority newPriority = this.driverTaskHandle.getPriority();
        Priority oldPriority = this.priority.getAndSet(newPriority);
        return newPriority.getLevel() != oldPriority.getLevel();
    }

    public void resetLevelScheduledTime() {
        this.priority.set(this.driverTaskHandle.resetLevelScheduledTime());
    }

    public long getLastEnterReadyQueueTime() {
        return this.lastEnterReadyQueueTime;
    }

    public void setLastEnterReadyQueueTime(long lastEnterReadyQueueTime) {
        this.lastEnterReadyQueueTime = lastEnterReadyQueueTime;
    }

    public long getLastEnterBlockQueueTime() {
        return this.lastEnterBlockQueueTime;
    }

    public void setLastEnterBlockQueueTime(long lastEnterBlockQueueTime) {
        this.lastEnterBlockQueueTime = lastEnterBlockQueueTime;
    }

    private static class StubFragmentInstance
    implements IDriver {
        private static final QueryId stubQueryId = new QueryId("stub_query");
        private static DriverTaskId stubDriver = new DriverTaskId(new FragmentInstanceId(new PlanFragmentId(stubQueryId, 0), "stub-instance"), 0);

        private StubFragmentInstance() {
        }

        @Override
        public boolean isFinished() {
            return false;
        }

        @Override
        public ListenableFuture<?> processFor(Duration duration) {
            return null;
        }

        @Override
        public DriverTaskId getDriverTaskId() {
            return stubDriver;
        }

        @Override
        public void setDriverTaskId(DriverTaskId driverTaskId) {
            stubDriver = driverTaskId;
        }

        @Override
        public void close() {
        }

        @Override
        public void failed(Throwable t) {
        }

        @Override
        public ISink getSink() {
            return null;
        }

        @Override
        public DriverContext getDriverContext() {
            return null;
        }
    }

    public static class SchedulePriorityComparator
    implements Comparator<DriverTask> {
        @Override
        public int compare(DriverTask o1, DriverTask o2) {
            if (o1.getDriverTaskId().equals(o2.getDriverTaskId())) {
                return 0;
            }
            int result = Long.compare(((Priority)o1.priority.get()).getLevelScheduledTime(), ((Priority)o2.priority.get()).getLevelScheduledTime());
            if (result != 0) {
                return result;
            }
            return o1.getDriverTaskId().compareTo(o2.getDriverTaskId());
        }
    }

    public static class TimeoutComparator
    implements Comparator<DriverTask> {
        @Override
        public int compare(DriverTask o1, DriverTask o2) {
            if (o1.getDriverTaskId().equals(o2.getDriverTaskId())) {
                return 0;
            }
            if (o1.getDDL() < o2.getDDL()) {
                return -1;
            }
            if (o1.getDDL() > o2.getDDL()) {
                return 1;
            }
            return o1.getDriverTaskId().compareTo(o2.getDriverTaskId());
        }
    }
}

