/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.last;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.AbstractUpdateLastCacheOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;

public class LastQueryOperator
implements ProcessOperator {
    private static final int MAX_DETECT_COUNT = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber();
    private final OperatorContext operatorContext;
    private final List<AbstractUpdateLastCacheOperator> children;
    private final int inputOperatorsCount;
    private int currentIndex;
    private TsBlockBuilder tsBlockBuilder;

    public LastQueryOperator(OperatorContext operatorContext, List<AbstractUpdateLastCacheOperator> children, TsBlockBuilder builder) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.inputOperatorsCount = children.size();
        this.currentIndex = 0;
        this.tsBlockBuilder = builder;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.currentIndex < this.inputOperatorsCount) {
            int endIndex = this.getEndIndex();
            ArrayList listenableFutures = new ArrayList();
            for (int i = this.currentIndex; i < endIndex; ++i) {
                ListenableFuture<?> blocked = this.children.get(i).isBlocked();
                if (blocked.isDone()) continue;
                listenableFutures.add(blocked);
            }
            return listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.currentIndex >= this.inputOperatorsCount) {
            TsBlock res = this.tsBlockBuilder.build();
            this.tsBlockBuilder.reset();
            return res;
        }
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        int endIndex = this.getEndIndex();
        while (System.nanoTime() - start < maxRuntime && this.currentIndex < endIndex && !this.tsBlockBuilder.isFull()) {
            if (this.children.get(this.currentIndex).hasNextWithTimer()) {
                TsBlock tsBlock = this.children.get(this.currentIndex).nextWithTimer();
                if (tsBlock == null) {
                    return null;
                }
                if (!tsBlock.isEmpty()) {
                    LastQueryUtil.appendLastValue(this.tsBlockBuilder, tsBlock);
                }
            } else {
                this.children.get(this.currentIndex).close();
                this.children.set(this.currentIndex, null);
            }
            ++this.currentIndex;
        }
        TsBlock res = this.tsBlockBuilder.build();
        this.tsBlockBuilder.reset();
        return res;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.currentIndex < this.inputOperatorsCount || !this.tsBlockBuilder.isEmpty();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        for (Operator operator : this.children) {
            if (operator == null) continue;
            operator.close();
        }
        this.tsBlockBuilder = null;
    }

    private int getEndIndex() {
        return this.currentIndex + Math.min(MAX_DETECT_COUNT, this.inputOperatorsCount - this.currentIndex);
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = Math.max((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, this.tsBlockBuilder.getRetainedSizeInBytes());
        long res = 0L;
        for (Operator operator : this.children) {
            res = Math.max(res, maxPeekMemory + operator.calculateMaxPeekMemory());
        }
        return res;
    }

    @Override
    public long calculateMaxReturnSize() {
        return Math.max((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, this.tsBlockBuilder.getRetainedSizeInBytes());
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long max = 0L;
        for (Operator operator : this.children) {
            max = Math.max(max, operator.calculateRetainedSizeAfterCallingNext());
        }
        return max;
    }
}

