/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.tools.DiskSpiller;
import org.apache.iotdb.db.tools.MemoryReader;
import org.apache.iotdb.db.tools.SortBufferManager;
import org.apache.iotdb.db.tools.SortReader;
import org.apache.iotdb.db.utils.datastructure.MergeSortHeap;
import org.apache.iotdb.db.utils.datastructure.MergeSortKey;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final Operator inputOperator;
    private final TsBlockBuilder tsBlockBuilder;
    private int curRow = -1;
    private List<SortKey> cachedData;
    private final Comparator<SortKey> comparator;
    private long cachedBytes;
    private final DiskSpiller diskSpiller;
    private final SortBufferManager sortBufferManager;
    private MergeSortHeap mergeSortHeap;
    private List<SortReader> sortReaders;
    private boolean[] noMoreData;
    private static final Logger logger = LoggerFactory.getLogger(SortOperator.class);

    public SortOperator(OperatorContext operatorContext, Operator inputOperator, List<TSDataType> dataTypes, String folderPath, Comparator<SortKey> comparator) {
        this.operatorContext = operatorContext;
        this.inputOperator = inputOperator;
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.cachedData = new ArrayList<SortKey>();
        this.comparator = comparator;
        this.cachedBytes = 0L;
        this.diskSpiller = new DiskSpiller(folderPath, folderPath + operatorContext.getOperatorId(), dataTypes);
        this.sortBufferManager = new SortBufferManager();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.inputOperator.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.inputOperator.hasNextWithTimer()) {
            if (this.diskSpiller.hasSpilledData()) {
                try {
                    this.prepareSortReaders();
                    return this.mergeSort();
                }
                catch (Exception e) {
                    this.clear();
                    throw e;
                }
            }
            if (this.curRow == -1) {
                this.cachedData.sort(this.comparator);
                this.curRow = 0;
            }
            return this.buildTsBlockInMemory();
        }
        TsBlock tsBlock = this.inputOperator.nextWithTimer();
        if (tsBlock == null) {
            return null;
        }
        try {
            this.cacheTsBlock(tsBlock);
        }
        catch (IoTDBException e) {
            this.clear();
            throw e;
        }
        return null;
    }

    private void prepareSortReaders() throws IoTDBException {
        if (this.sortReaders != null) {
            return;
        }
        this.sortReaders = new ArrayList<SortReader>();
        if (this.cachedBytes != 0L) {
            this.cachedData.sort(this.comparator);
            if (this.sortBufferManager.allocate(this.cachedBytes)) {
                this.sortReaders.add(new MemoryReader(this.cachedData.stream().map(MergeSortKey::new).collect(Collectors.toList())));
            } else {
                this.sortBufferManager.allocateOneSortBranch();
                this.diskSpiller.spillSortedData(this.cachedData);
                this.cachedData = null;
            }
        }
        this.sortReaders.addAll(this.diskSpiller.getReaders(this.sortBufferManager));
        this.noMoreData = new boolean[this.sortReaders.size()];
    }

    private void cacheTsBlock(TsBlock tsBlock) throws IoTDBException {
        long bytesSize = tsBlock.getRetainedSizeInBytes();
        if (bytesSize + this.cachedBytes < SortBufferManager.SORT_BUFFER_SIZE) {
            this.cachedBytes += bytesSize;
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                this.cachedData.add(new MergeSortKey(tsBlock, i));
            }
        } else {
            this.cachedData.sort(this.comparator);
            this.spill();
            this.cachedData.clear();
            this.cachedBytes = bytesSize;
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                this.cachedData.add(new MergeSortKey(tsBlock, i));
            }
        }
    }

    private void spill() throws IoTDBException {
        this.sortBufferManager.allocateOneSortBranch();
        this.diskSpiller.spillSortedData(this.cachedData);
    }

    private TsBlock buildTsBlockInMemory() {
        this.tsBlockBuilder.reset();
        TimeColumnBuilder timeColumnBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
        for (int i = this.curRow; i < this.cachedData.size(); ++i) {
            SortKey sortKey = this.cachedData.get(i);
            TsBlock tsBlock = sortKey.tsBlock;
            timeColumnBuilder.writeLong(tsBlock.getTimeByIndex(sortKey.rowIndex));
            for (int j = 0; j < valueColumnBuilders.length; ++j) {
                if (tsBlock.getColumn(j).isNull(sortKey.rowIndex)) {
                    valueColumnBuilders[j].appendNull();
                    continue;
                }
                valueColumnBuilders[j].write(tsBlock.getColumn(j), sortKey.rowIndex);
            }
            this.tsBlockBuilder.declarePosition();
            ++this.curRow;
            if (this.tsBlockBuilder.isFull()) break;
        }
        return this.tsBlockBuilder.build();
    }

    private TsBlock mergeSort() throws IoTDBException {
        if (this.mergeSortHeap == null) {
            this.mergeSortHeap = new MergeSortHeap(this.sortReaders.size(), this.comparator);
            for (int i = 0; i < this.sortReaders.size(); ++i) {
                SortReader sortReader = this.sortReaders.get(i);
                if (sortReader.hasNext()) {
                    MergeSortKey mergeSortKey = sortReader.next();
                    mergeSortKey.inputChannelIndex = i;
                    this.mergeSortHeap.push(mergeSortKey);
                    continue;
                }
                this.noMoreData[i] = true;
                this.sortBufferManager.releaseOneSortBranch();
            }
        }
        long startTime = System.nanoTime();
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        this.tsBlockBuilder.reset();
        TimeColumnBuilder timeBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
        while (!this.mergeSortHeap.isEmpty()) {
            MergeSortKey mergeSortKey = this.mergeSortHeap.poll();
            TsBlock targetBlock = mergeSortKey.tsBlock;
            timeBuilder.writeLong(targetBlock.getTimeByIndex(mergeSortKey.rowIndex));
            for (int i = 0; i < valueColumnBuilders.length; ++i) {
                if (targetBlock.getColumn(i).isNull(mergeSortKey.rowIndex)) {
                    valueColumnBuilders[i].appendNull();
                    continue;
                }
                valueColumnBuilders[i].write(targetBlock.getColumn(i), mergeSortKey.rowIndex);
            }
            this.tsBlockBuilder.declarePosition();
            int readerIndex = mergeSortKey.inputChannelIndex;
            mergeSortKey = this.readNextMergeSortKey(readerIndex);
            if (mergeSortKey != null) {
                this.mergeSortHeap.push(mergeSortKey);
            } else {
                this.noMoreData[readerIndex] = true;
                this.sortBufferManager.releaseOneSortBranch();
            }
            if (System.nanoTime() - startTime <= maxRuntime && !this.tsBlockBuilder.isFull()) continue;
            break;
        }
        return this.tsBlockBuilder.build();
    }

    private MergeSortKey readNextMergeSortKey(int readerIndex) throws IoTDBException {
        SortReader sortReader = this.sortReaders.get(readerIndex);
        if (sortReader.hasNext()) {
            MergeSortKey mergeSortKey = sortReader.next();
            mergeSortKey.inputChannelIndex = readerIndex;
            return mergeSortKey;
        }
        return null;
    }

    private boolean hasMoreData() {
        if (this.noMoreData == null) {
            return true;
        }
        for (boolean noMore : this.noMoreData) {
            if (noMore) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        if (!this.diskSpiller.hasSpilledData()) {
            return;
        }
        try {
            if (this.sortReaders != null) {
                for (SortReader sortReader : this.sortReaders) {
                    sortReader.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("Fail to close fileChannel", (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.inputOperator.hasNextWithTimer() || !this.diskSpiller.hasSpilledData() && this.curRow != this.cachedData.size() || this.diskSpiller.hasSpilledData() && this.hasMoreData();
    }

    @Override
    public void close() throws Exception {
        this.cachedData = null;
        this.clear();
        this.inputOperator.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.inputOperator.calculateMaxPeekMemory() + this.inputOperator.calculateRetainedSizeAfterCallingNext() + SortBufferManager.SORT_BUFFER_SIZE;
    }

    @Override
    public long calculateMaxReturnSize() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.inputOperator.calculateRetainedSizeAfterCallingNext() + SortBufferManager.SORT_BUFFER_SIZE;
    }
}

