/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.fragment;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;

public enum FragmentState {
    PLANNED(false, false),
    SCHEDULING(false, false),
    RUNNING(false, false),
    PENDING(false, false),
    FINISHED(true, false),
    ABORTED(true, true),
    FAILED(true, true);

    public static final Set<FragmentState> TERMINAL_FRAGMENT_STATES;
    private final boolean doneState;
    private final boolean failureState;

    private FragmentState(boolean doneState, boolean failureState) {
        Preconditions.checkArgument((!failureState || doneState ? 1 : 0) != 0, (String)"%s is a non-done failure state", (Object)this.name());
        this.doneState = doneState;
        this.failureState = failureState;
    }

    public boolean isDone() {
        return this.doneState;
    }

    public boolean isFailure() {
        return this.failureState;
    }

    static {
        TERMINAL_FRAGMENT_STATES = (Set)Stream.of(FragmentState.values()).filter(FragmentState::isDone).collect(ImmutableSet.toImmutableSet());
    }
}

