/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.schematree;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.MeasurementSchemaInfo;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class DeviceSchemaInfo {
    private PartialPath devicePath;
    private boolean isAligned;
    private List<MeasurementSchemaInfo> measurementSchemaInfoList;

    private DeviceSchemaInfo() {
    }

    public DeviceSchemaInfo(PartialPath devicePath, boolean isAligned, List<MeasurementSchemaInfo> measurementSchemaInfoList) {
        this.devicePath = devicePath;
        this.isAligned = isAligned;
        this.measurementSchemaInfoList = measurementSchemaInfoList;
    }

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public List<MeasurementSchema> getMeasurementSchemaList() {
        return this.measurementSchemaInfoList.stream().map(measurementSchemaInfo -> measurementSchemaInfo == null ? null : measurementSchemaInfo.getSchemaAsMeasurementSchema()).collect(Collectors.toList());
    }

    public List<MeasurementPath> getMeasurements(Set<String> measurements) {
        if (measurements.contains("*")) {
            return this.measurementSchemaInfoList.stream().map(measurementInfo -> {
                if (measurementInfo == null) {
                    return null;
                }
                MeasurementPath measurementPath = new MeasurementPath(this.devicePath.concatNode(measurementInfo.getName()), measurementInfo.getSchema());
                if (measurementInfo.getAlias() != null) {
                    measurementPath.setMeasurementAlias(measurementInfo.getAlias());
                }
                measurementPath.setUnderAlignedEntity(Boolean.valueOf(this.isAligned));
                return measurementPath;
            }).collect(Collectors.toList());
        }
        ArrayList<MeasurementPath> measurementPaths = new ArrayList<MeasurementPath>();
        for (IMeasurementSchemaInfo iMeasurementSchemaInfo : this.measurementSchemaInfoList) {
            MeasurementPath measurementPath = new MeasurementPath(this.devicePath.concatNode(iMeasurementSchemaInfo.getName()), iMeasurementSchemaInfo.getSchema());
            measurementPath.setUnderAlignedEntity(Boolean.valueOf(this.isAligned));
            if (measurements.contains(iMeasurementSchemaInfo.getName())) {
                measurementPaths.add(measurementPath);
                continue;
            }
            if (iMeasurementSchemaInfo.getAlias() == null || !measurements.contains(iMeasurementSchemaInfo.getAlias())) continue;
            measurementPath.setMeasurementAlias(iMeasurementSchemaInfo.getAlias());
            measurementPaths.add(measurementPath);
        }
        return measurementPaths;
    }
}

