/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.IReleaseFlushStrategy;
import org.apache.iotdb.db.metadata.rescon.CachedSchemaEngineStatistics;

public class ReleaseFlushStrategyNumBasedImpl
implements IReleaseFlushStrategy {
    private final int capacity;
    private final CachedSchemaEngineStatistics engineStatistics;

    public ReleaseFlushStrategyNumBasedImpl(CachedSchemaEngineStatistics engineStatistics) {
        this.engineStatistics = engineStatistics;
        this.capacity = IoTDBDescriptor.getInstance().getConfig().getCachedMNodeSizeInPBTreeMode();
    }

    @Override
    public boolean isExceedReleaseThreshold() {
        return (double)(this.engineStatistics.getPinnedMNodeNum() + this.engineStatistics.getUnpinnedMNodeNum()) > (double)this.capacity * 0.6;
    }

    @Override
    public boolean isExceedFlushThreshold() {
        return this.engineStatistics.getPinnedMNodeNum() + this.engineStatistics.getUnpinnedMNodeNum() > (long)this.capacity;
    }
}

