/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode.mem.impl;

import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.db.metadata.mnode.mem.IMemMNode;
import org.apache.iotdb.db.metadata.mnode.mem.basic.BasicMNode;
import org.apache.iotdb.db.metadata.mnode.mem.container.MemMNodeContainer;

public class BasicInternalMNode
extends BasicMNode {
    private volatile transient IMNodeContainer<IMemMNode> children = null;

    public BasicInternalMNode(IMemMNode parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean hasChild(String name) {
        return this.children != null && this.children.containsKey((Object)name);
    }

    @Override
    public IMemMNode getChild(String name) {
        IMemMNode child = null;
        if (this.children != null) {
            child = (IMemMNode)this.children.get((Object)name);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMemMNode addChild(String name, IMemMNode child) {
        if (this.children == null) {
            BasicInternalMNode basicInternalMNode = this;
            synchronized (basicInternalMNode) {
                if (this.children == null) {
                    this.children = new MemMNodeContainer();
                }
            }
        }
        child.setParent(this);
        IMemMNode existingChild = (IMemMNode)this.children.putIfAbsent((Object)name, (Object)child);
        return existingChild == null ? child : existingChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMemMNode addChild(IMemMNode child) {
        if (this.children == null) {
            BasicInternalMNode basicInternalMNode = this;
            synchronized (basicInternalMNode) {
                if (this.children == null) {
                    this.children = new MemMNodeContainer();
                }
            }
        }
        child.setParent(this);
        this.children.putIfAbsent((Object)child.getName(), (Object)child);
        return child;
    }

    @Override
    public IMemMNode deleteChild(String name) {
        if (this.children != null) {
            return (IMemMNode)this.children.remove((Object)name);
        }
        return null;
    }

    @Override
    public synchronized void replaceChild(String oldChildName, IMemMNode newChildNode) {
        if (!oldChildName.equals(newChildNode.getName())) {
            throw new RuntimeException("New child's name must be the same as old child's name!");
        }
        IMemMNode oldChildNode = this.getChild(oldChildName);
        if (oldChildNode == null) {
            return;
        }
        oldChildNode.moveDataToNewMNode(newChildNode);
        this.children.replace((Object)newChildNode.getName(), (Object)newChildNode);
    }

    @Override
    public void moveDataToNewMNode(IMemMNode newMNode) {
        super.moveDataToNewMNode(newMNode);
        if (this.children != null) {
            newMNode.setChildren(this.children);
            this.children.forEach((childName, childNode) -> childNode.setParent(newMNode));
        }
    }

    @Override
    public IMNodeContainer<IMemMNode> getChildren() {
        if (this.children == null) {
            return MemMNodeContainer.emptyMNodeContainer();
        }
        return this.children;
    }

    @Override
    public void setChildren(IMNodeContainer<IMemMNode> children) {
        this.children = children;
    }

    @Override
    public int estimateSize() {
        return 88 + super.estimateSize();
    }

    @Override
    public IMemMNode getAsMNode() {
        return this;
    }
}

