/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.idtable.AppendOnlyDiskSchemaManager;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.IDiskSchemaManager;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceEntry;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.idtable.entry.DiskSchemaEntry;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.idtable.entry.SchemaEntry;
import org.apache.iotdb.db.metadata.idtable.entry.TimeseriesID;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateTimeSeriesPlan;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDTableHashmapImpl
implements IDTable {
    private static final int NUM_OF_SLOTS = 256;
    private static final Logger logger = LoggerFactory.getLogger(IDTableHashmapImpl.class);
    private Map<IDeviceID, DeviceEntry>[] idTables = new Map[256];
    private IDiskSchemaManager IDiskSchemaManager;
    protected static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public IDTableHashmapImpl(File storageGroupDir) {
        for (int i = 0; i < 256; ++i) {
            this.idTables[i] = new HashMap<IDeviceID, DeviceEntry>();
        }
        if (config.isEnableIDTableLogFile()) {
            this.IDiskSchemaManager = new AppendOnlyDiskSchemaManager(storageGroupDir);
            this.IDiskSchemaManager.recover(this);
        }
    }

    @Override
    public synchronized void createAlignedTimeseries(ICreateAlignedTimeSeriesPlan plan) throws MetadataException {
        DeviceEntry deviceEntry = this.getDeviceEntryWithAlignedCheck(plan.getDevicePath().toString(), true);
        for (int i = 0; i < plan.getMeasurements().size(); ++i) {
            PartialPath fullPath = new PartialPath(plan.getDevicePath().toString(), plan.getMeasurements().get(i));
            SchemaEntry schemaEntry = new SchemaEntry(plan.getDataTypes().get(i), plan.getEncodings().get(i), plan.getCompressors().get(i), deviceEntry.getDeviceID(), fullPath, true, this.IDiskSchemaManager);
            deviceEntry.putSchemaEntry(plan.getMeasurements().get(i), schemaEntry);
        }
    }

    @Override
    public synchronized void createTimeseries(ICreateTimeSeriesPlan plan) throws MetadataException {
        DeviceEntry deviceEntry = this.getDeviceEntryWithAlignedCheck(plan.getPath().getDevice(), false);
        SchemaEntry schemaEntry = new SchemaEntry(plan.getDataType(), plan.getEncoding(), plan.getCompressor(), deviceEntry.getDeviceID(), plan.getPath(), false, this.IDiskSchemaManager);
        deviceEntry.putSchemaEntry(plan.getPath().getMeasurement(), schemaEntry);
    }

    @Override
    public synchronized Pair<Integer, Set<String>> deleteTimeseries(List<PartialPath> fullPaths) throws MetadataException {
        int deletedNum = 0;
        HashSet<String> failedNames = new HashSet<String>();
        ArrayList<Pair> deletedPairs = new ArrayList<Pair>(fullPaths.size());
        for (PartialPath fullPath : fullPaths) {
            Map<String, SchemaEntry> map = this.getDeviceEntry(fullPath.getDevice()).getMeasurementMap();
            if (map == null) {
                failedNames.add(fullPath.getFullPath());
                continue;
            }
            SchemaEntry schemaEntry = map.get(fullPath.getMeasurement());
            if (schemaEntry == null) {
                failedNames.add(fullPath.getFullPath());
                continue;
            }
            deletedPairs.add(new Pair((Object)fullPath, (Object)schemaEntry.getDiskPointer()));
        }
        deletedPairs.sort(Comparator.comparingLong(o -> (Long)o.right));
        for (Pair pair : deletedPairs) {
            try {
                this.getIDiskSchemaManager().deleteDiskSchemaEntryByOffset((Long)pair.right);
                DeviceEntry deviceEntry = this.getDeviceEntry(((PartialPath)pair.left).getDevice());
                Map<String, SchemaEntry> map = this.getDeviceEntry(((PartialPath)pair.left).getDevice()).getMeasurementMap();
                map.keySet().remove(((PartialPath)pair.left).getMeasurement());
                ++deletedNum;
            }
            catch (MetadataException e) {
                failedNames.add(((PartialPath)pair.left).getFullPath());
            }
        }
        return new Pair((Object)deletedNum, failedNames);
    }

    @Override
    public void clear() throws IOException {
        if (this.IDiskSchemaManager != null) {
            this.IDiskSchemaManager.close();
        }
    }

    @Override
    public DeviceEntry getDeviceEntry(String deviceName) {
        IDeviceID deviceID = DeviceIDFactory.getInstance().getDeviceID(deviceName);
        int slot = this.calculateSlot(deviceID);
        return this.idTables[slot].get(deviceID);
    }

    @Override
    public IMeasurementSchema getSeriesSchema(String deviceName, String measurementName) {
        DeviceEntry deviceEntry = this.getDeviceEntry(deviceName);
        if (deviceEntry == null) {
            return null;
        }
        SchemaEntry schemaEntry = deviceEntry.getSchemaEntry(measurementName);
        if (schemaEntry == null) {
            return null;
        }
        return new MeasurementSchema(measurementName, schemaEntry.getTSDataType(), schemaEntry.getTSEncoding(), schemaEntry.getCompressionType());
    }

    @Override
    public List<DeviceEntry> getAllDeviceEntry() {
        ArrayList<DeviceEntry> res = new ArrayList<DeviceEntry>();
        for (int i = 0; i < 256; ++i) {
            res.addAll(this.idTables[i].values());
        }
        return res;
    }

    @Override
    public void putSchemaEntry(String devicePath, String measurement, SchemaEntry schemaEntry, boolean isAligned) throws MetadataException {
        DeviceEntry deviceEntry = this.getDeviceEntryWithAlignedCheck(devicePath, isAligned);
        deviceEntry.putSchemaEntry(measurement, schemaEntry);
    }

    @Override
    public synchronized List<DiskSchemaEntry> getDiskSchemaEntries(List<SchemaEntry> schemaEntries) {
        ArrayList<Long> offsets = new ArrayList<Long>(schemaEntries.size());
        for (SchemaEntry schemaEntry : schemaEntries) {
            offsets.add(schemaEntry.getDiskPointer());
        }
        return this.getIDiskSchemaManager().getDiskSchemaEntriesByOffset(offsets);
    }

    private DeviceEntry getDeviceEntryWithAlignedCheck(String deviceName, boolean isAligned) throws MetadataException {
        IDeviceID deviceID = DeviceIDFactory.getInstance().getDeviceID(deviceName);
        int slot = this.calculateSlot(deviceID);
        DeviceEntry deviceEntry = this.idTables[slot].get(deviceID);
        if (deviceEntry == null) {
            deviceEntry = new DeviceEntry(deviceID);
            deviceEntry.setAligned(isAligned);
            this.idTables[slot].put(deviceID, deviceEntry);
            return deviceEntry;
        }
        if (deviceEntry.isAligned() != isAligned) {
            throw new MetadataException(String.format("Timeseries under path [%s]'s align value is [%b], which is not consistent with insert plan", deviceName, deviceEntry.isAligned()));
        }
        return deviceEntry;
    }

    private int calculateSlot(IDeviceID deviceID) {
        int hashVal = deviceID.hashCode();
        return Math.abs(hashVal == Integer.MIN_VALUE ? 0 : hashVal) % 256;
    }

    private SchemaEntry getSchemaEntry(TimeseriesID timeseriesID) throws MetadataException {
        IDeviceID deviceID = timeseriesID.getDeviceID();
        int slot = this.calculateSlot(deviceID);
        DeviceEntry deviceEntry = this.idTables[slot].get(deviceID);
        if (deviceEntry == null) {
            throw new MetadataException("get non exist timeseries's schema entry, timeseries id is: " + timeseriesID);
        }
        SchemaEntry schemaEntry = deviceEntry.getSchemaEntry(timeseriesID.getMeasurement());
        if (schemaEntry == null) {
            throw new MetadataException("get non exist timeseries's schema entry, timeseries id is: " + timeseriesID);
        }
        return schemaEntry;
    }

    @Override
    public Map<IDeviceID, DeviceEntry>[] getIdTables() {
        return this.idTables;
    }

    @Override
    public IDiskSchemaManager getIDiskSchemaManager() {
        return this.IDiskSchemaManager;
    }
}

