/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.load;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.load.ChunkData;
import org.apache.iotdb.db.engine.load.TsFileData;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.load.LoadTsFilePieceNode;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileManager {
    private static final Logger logger = LoggerFactory.getLogger(LoadTsFileManager.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final File loadDir = SystemFileFactory.INSTANCE.getFile(config.getLoadTsFileDir());
    private final Map<String, TsFileWriterManager> uuid2WriterManager = new ConcurrentHashMap<String, TsFileWriterManager>();
    private final ScheduledExecutorService cleanupExecutors = IoTDBThreadPoolFactory.newScheduledThreadPool((int)0, (String)LoadTsFileManager.class.getName());
    private final Map<String, ScheduledFuture<?>> uuid2Future = new ConcurrentHashMap();

    public LoadTsFileManager() {
        this.recover();
    }

    private void recover() {
        if (!this.loadDir.exists()) {
            return;
        }
        File[] files = this.loadDir.listFiles();
        if (files == null) {
            return;
        }
        for (File taskDir : files) {
            String uuid = taskDir.getName();
            TsFileWriterManager writerManager = new TsFileWriterManager(taskDir);
            this.uuid2WriterManager.put(uuid, writerManager);
            writerManager.close();
            this.uuid2Future.put(uuid, this.cleanupExecutors.schedule(() -> this.forceCloseWriterManager(uuid), 5184000L, TimeUnit.SECONDS));
        }
    }

    public void writeToDataRegion(DataRegion dataRegion, LoadTsFilePieceNode pieceNode, String uuid) throws PageException, IOException {
        if (!this.uuid2WriterManager.containsKey(uuid)) {
            this.uuid2Future.put(uuid, this.cleanupExecutors.schedule(() -> this.forceCloseWriterManager(uuid), 5184000L, TimeUnit.SECONDS));
        }
        TsFileWriterManager writerManager = this.uuid2WriterManager.computeIfAbsent(uuid, o -> new TsFileWriterManager(SystemFileFactory.INSTANCE.getFile(this.loadDir, uuid)));
        for (TsFileData tsFileData : pieceNode.getAllTsFileData()) {
            if (!tsFileData.isModification()) {
                ChunkData chunkData = (ChunkData)tsFileData;
                writerManager.write(new DataPartitionInfo(dataRegion, chunkData.getTimePartitionSlot()), chunkData);
                continue;
            }
            writerManager.writeDeletion(tsFileData);
        }
    }

    public boolean loadAll(String uuid) throws IOException, LoadFileException {
        if (!this.uuid2WriterManager.containsKey(uuid)) {
            return false;
        }
        this.uuid2WriterManager.get(uuid).loadAll();
        this.clean(uuid);
        return true;
    }

    public boolean deleteAll(String uuid) throws IOException {
        if (!this.uuid2WriterManager.containsKey(uuid)) {
            return false;
        }
        this.clean(uuid);
        return true;
    }

    private void clean(String uuid) {
        this.uuid2WriterManager.get(uuid).close();
        this.uuid2WriterManager.remove(uuid);
        this.uuid2Future.get(uuid).cancel(true);
        this.uuid2Future.remove(uuid);
        if (this.loadDir.delete()) {
            logger.info("Delete load dir {}.", (Object)this.loadDir.getPath());
        }
    }

    private void forceCloseWriterManager(String uuid) {
        this.uuid2WriterManager.get(uuid).close();
        this.uuid2WriterManager.remove(uuid);
        this.uuid2Future.remove(uuid);
        if (this.loadDir.delete()) {
            logger.info("Delete load dir {}.", (Object)this.loadDir.getPath());
        }
    }

    private class DataPartitionInfo {
        private final DataRegion dataRegion;
        private final TTimePartitionSlot timePartitionSlot;

        private DataPartitionInfo(DataRegion dataRegion, TTimePartitionSlot timePartitionSlot) {
            this.dataRegion = dataRegion;
            this.timePartitionSlot = timePartitionSlot;
        }

        public DataRegion getDataRegion() {
            return this.dataRegion;
        }

        public TTimePartitionSlot getTimePartitionSlot() {
            return this.timePartitionSlot;
        }

        public String toString() {
            return String.join((CharSequence)"-", this.dataRegion.getDatabaseName(), this.dataRegion.getDataRegionId(), Long.toString(this.timePartitionSlot.getStartTime()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataPartitionInfo that = (DataPartitionInfo)o;
            return Objects.equals(this.dataRegion, that.dataRegion) && this.timePartitionSlot.getStartTime() == that.timePartitionSlot.getStartTime();
        }

        public int hashCode() {
            return Objects.hash(this.dataRegion, this.timePartitionSlot.getStartTime());
        }
    }

    private class TsFileWriterManager {
        private final File taskDir;
        private Map<DataPartitionInfo, TsFileIOWriter> dataPartition2Writer;
        private Map<DataPartitionInfo, String> dataPartition2LastDevice;
        private boolean isClosed;

        private TsFileWriterManager(File taskDir) {
            this.taskDir = taskDir;
            this.dataPartition2Writer = new HashMap<DataPartitionInfo, TsFileIOWriter>();
            this.dataPartition2LastDevice = new HashMap<DataPartitionInfo, String>();
            this.isClosed = false;
            this.clearDir(taskDir);
        }

        private void clearDir(File dir) {
            if (dir.exists()) {
                FileUtils.deleteDirectory((File)dir);
            }
            if (dir.mkdirs()) {
                logger.info("Load TsFile dir {} is created.", (Object)dir.getPath());
            }
        }

        private void write(DataPartitionInfo partitionInfo, ChunkData chunkData) throws IOException {
            if (this.isClosed) {
                throw new IOException(String.format("%s TsFileWriterManager has been closed.", this.taskDir));
            }
            if (!this.dataPartition2Writer.containsKey(partitionInfo)) {
                File newTsFile = SystemFileFactory.INSTANCE.getFile(this.taskDir, partitionInfo.toString() + ".tsfile");
                if (!newTsFile.createNewFile()) {
                    logger.error("Can not create TsFile {} for writing.", (Object)newTsFile.getPath());
                    return;
                }
                this.dataPartition2Writer.put(partitionInfo, new TsFileIOWriter(newTsFile));
            }
            TsFileIOWriter writer = this.dataPartition2Writer.get(partitionInfo);
            if (!chunkData.getDevice().equals(this.dataPartition2LastDevice.getOrDefault(partitionInfo, ""))) {
                if (this.dataPartition2LastDevice.containsKey(partitionInfo)) {
                    writer.endChunkGroup();
                }
                writer.startChunkGroup(chunkData.getDevice());
                this.dataPartition2LastDevice.put(partitionInfo, chunkData.getDevice());
            }
            chunkData.writeToFileWriter(writer);
        }

        private void writeDeletion(TsFileData deletionData) throws IOException {
            if (this.isClosed) {
                throw new IOException(String.format("%s TsFileWriterManager has been closed.", this.taskDir));
            }
            for (Map.Entry<DataPartitionInfo, TsFileIOWriter> entry : this.dataPartition2Writer.entrySet()) {
                deletionData.writeToFileWriter(entry.getValue());
            }
        }

        private void loadAll() throws IOException, LoadFileException {
            if (this.isClosed) {
                throw new IOException(String.format("%s TsFileWriterManager has been closed.", this.taskDir));
            }
            for (Map.Entry<DataPartitionInfo, TsFileIOWriter> entry : this.dataPartition2Writer.entrySet()) {
                TsFileIOWriter writer = entry.getValue();
                if (writer.isWritingChunkGroup()) {
                    writer.endChunkGroup();
                }
                writer.endFile();
                entry.getKey().getDataRegion().loadNewTsFile(this.generateResource(writer), true);
            }
        }

        private TsFileResource generateResource(TsFileIOWriter writer) throws IOException {
            TsFileResource tsFileResource = FileLoaderUtils.generateTsFileResource(writer);
            tsFileResource.serialize();
            return tsFileResource;
        }

        private void close() {
            if (this.isClosed) {
                return;
            }
            if (this.dataPartition2Writer != null) {
                for (Map.Entry<DataPartitionInfo, TsFileIOWriter> entry : this.dataPartition2Writer.entrySet()) {
                    try {
                        TsFileIOWriter writer = entry.getValue();
                        if (writer.canWrite()) {
                            writer.close();
                        }
                        if (!writer.getFile().exists() || writer.getFile().delete()) continue;
                        logger.warn("Delete File {} error.", (Object)writer.getFile());
                    }
                    catch (IOException e) {
                        logger.warn(String.format("Close TsFileIOWriter %s error.", entry.getValue().getFile().getPath()), (Throwable)e);
                    }
                }
            }
            if (!this.taskDir.delete()) {
                logger.warn("Can not delete load dir {}.", (Object)this.taskDir.getPath());
            }
            this.dataPartition2Writer = null;
            this.dataPartition2LastDevice = null;
            this.isClosed = true;
        }
    }
}

