/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.execute.utils.executor.fast.element;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.engine.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.AlignedChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;

public class PageElement {
    public PageHeader pageHeader;
    public List<PageHeader> valuePageHeaders;
    public TsBlock batchData;
    public ByteBuffer pageData;
    public List<ByteBuffer> valuePageDatas;
    public IChunkReader iChunkReader;
    public long priority;
    public long startTime;
    public boolean isSelected = false;
    public boolean isLastPage;
    public ChunkMetadataElement chunkMetadataElement;

    public PageElement(PageHeader pageHeader, ByteBuffer pageData, ChunkReader chunkReader, ChunkMetadataElement chunkMetadataElement, boolean isLastPage, long priority) {
        this.pageHeader = pageHeader;
        this.pageData = pageData;
        this.priority = priority;
        this.iChunkReader = chunkReader;
        this.startTime = pageHeader.getStartTime();
        this.chunkMetadataElement = chunkMetadataElement;
        this.isLastPage = isLastPage;
    }

    public PageElement(PageHeader timePageHeader, List<PageHeader> valuePageHeaders, ByteBuffer timePageData, List<ByteBuffer> valuePageDatas, AlignedChunkReader alignedChunkReader, ChunkMetadataElement chunkMetadataElement, boolean isLastPage, long priority) {
        this.pageHeader = timePageHeader;
        this.valuePageHeaders = valuePageHeaders;
        this.pageData = timePageData;
        this.valuePageDatas = valuePageDatas;
        this.priority = priority;
        this.iChunkReader = alignedChunkReader;
        this.startTime = this.pageHeader.getStartTime();
        this.chunkMetadataElement = chunkMetadataElement;
        this.isLastPage = isLastPage;
    }

    public void deserializePage() throws IOException {
        this.batchData = this.iChunkReader instanceof AlignedChunkReader ? ((AlignedChunkReader)this.iChunkReader).readPageData(this.pageHeader, this.valuePageHeaders, this.pageData, this.valuePageDatas) : ((ChunkReader)this.iChunkReader).readPageData(this.pageHeader, this.pageData);
    }
}

