/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.consensus.request.read.template.CheckTemplateSettablePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.PreSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.response.template.TemplateInfoResp;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionTaskExecutor;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.SetTemplateState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.db.exception.metadata.template.TemplateImcompatibeException;
import org.apache.iotdb.db.exception.metadata.template.UndefinedTemplateException;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.template.TemplateInternalRPCUpdateType;
import org.apache.iotdb.db.metadata.template.TemplateInternalRPCUtil;
import org.apache.iotdb.mpp.rpc.thrift.TCheckTimeSeriesExistenceReq;
import org.apache.iotdb.mpp.rpc.thrift.TCheckTimeSeriesExistenceResp;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTemplateReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetTemplateProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, SetTemplateState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetTemplateProcedure.class);
    private String queryId;
    private String templateName;
    private String templateSetPath;

    public SetTemplateProcedure() {
    }

    public SetTemplateProcedure(String queryId, String templateName, String templateSetPath) {
        this.queryId = queryId;
        this.templateName = templateName;
        this.templateSetPath = templateSetPath;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, SetTemplateState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateTemplateExistence(ConfigNodeProcedureEnv env) {
        CheckTemplateSettablePlan checkTemplateSettablePlan = new CheckTemplateSettablePlan(this.templateName, this.templateSetPath);
        TemplateInfoResp resp = (TemplateInfoResp)env.getConfigManager().getConsensusManager().read(checkTemplateSettablePlan).getDataset();
        if (resp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(SetTemplateState.PRE_SET);
        } else {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(resp.getStatus().getMessage(), resp.getStatus().getCode())));
        }
    }

    private void preSetTemplate(ConfigNodeProcedureEnv env) {
        PreSetSchemaTemplatePlan preSetSchemaTemplatePlan = new PreSetSchemaTemplatePlan(this.templateName, this.templateSetPath);
        TSStatus status = env.getConfigManager().getConsensusManager().write(preSetSchemaTemplatePlan).getStatus();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(SetTemplateState.PRE_RELEASE);
        } else {
            LOGGER.warn("Failed to pre set template {} on path {} due to {}", new Object[]{this.templateName, this.templateSetPath, status.getMessage()});
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    private void preReleaseTemplate(ConfigNodeProcedureEnv env) {
        Template template = this.getTemplate(env);
        if (template == null) {
            return;
        }
        TUpdateTemplateReq req = new TUpdateTemplateReq();
        req.setType(TemplateInternalRPCUpdateType.ADD_TEMPLATE_PRE_SET_INFO.toByte());
        req.setTemplateInfo(TemplateInternalRPCUtil.generateAddTemplateSetInfoBytes((Template)template, (String)this.templateSetPath));
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.UPDATE_TEMPLATE, req, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (Map.Entry entry : statusMap.entrySet()) {
            if (((TSStatus)entry.getValue()).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.warn("Failed to sync template {} pre-set info on path {} to DataNode {}", new Object[]{this.templateName, this.templateSetPath, dataNodeLocationMap.get(entry.getKey())});
            this.setFailure(new ProcedureException(new MetadataException("Pre set template failed")));
            return;
        }
        this.setNextState(SetTemplateState.VALIDATE_TIMESERIES_EXISTENCE);
    }

    private Template getTemplate(ConfigNodeProcedureEnv env) {
        GetSchemaTemplatePlan getSchemaTemplatePlan = new GetSchemaTemplatePlan(this.templateName);
        TemplateInfoResp templateResp = (TemplateInfoResp)env.getConfigManager().getConsensusManager().read(getSchemaTemplatePlan).getDataset();
        if (templateResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(templateResp.getStatus().getMessage(), templateResp.getStatus().getCode())));
            return null;
        }
        if (templateResp.getTemplateList() == null || templateResp.getTemplateList().isEmpty()) {
            this.setFailure(new ProcedureException((Throwable)new UndefinedTemplateException(this.templateName)));
            return null;
        }
        return templateResp.getTemplateList().get(0);
    }

    private void validateTimeSeriesExistence(ConfigNodeProcedureEnv env) {
        PathPatternTree patternTree = new PathPatternTree();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        PartialPath path = null;
        try {
            path = new PartialPath(this.templateSetPath);
            patternTree.appendPathPattern(path);
            patternTree.appendPathPattern(path.concatNode("**"));
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException | IllegalPathException throwable) {
            // empty catch block
        }
        ByteBuffer patternTreeBytes = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        Map<TConsensusGroupId, TRegionReplicaSet> relatedSchemaRegionGroup = env.getConfigManager().getRelatedSchemaRegionGroup(patternTree);
        final ArrayList respList = new ArrayList();
        DataNodeRegionTaskExecutor<TCheckTimeSeriesExistenceReq, TCheckTimeSeriesExistenceResp> regionTask = new DataNodeRegionTaskExecutor<TCheckTimeSeriesExistenceReq, TCheckTimeSeriesExistenceResp>(env, relatedSchemaRegionGroup, false, DataNodeRequestType.CHECK_TIMESERIES_EXISTENCE, (dataNodeLocation, consensusGroupIdList) -> new TCheckTimeSeriesExistenceReq(patternTreeBytes, consensusGroupIdList)){

            @Override
            protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TCheckTimeSeriesExistenceResp response) {
                respList.add(response);
                ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
                if (response.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    return failedRegionList;
                }
                if (response.getStatus().getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    List subStatus = response.getStatus().getSubStatus();
                    for (int i = 0; i < subStatus.size(); ++i) {
                        if (((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || ((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) continue;
                        failedRegionList.add(consensusGroupIdList.get(i));
                    }
                } else {
                    failedRegionList.addAll(consensusGroupIdList);
                }
                return failedRegionList;
            }

            @Override
            protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
                SetTemplateProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("Set template %s to %s failed when [check timeseries existence on DataNode] because all replicaset of schemaRegion %s failed. %s", SetTemplateProcedure.this.templateName, SetTemplateProcedure.this.templateSetPath, consensusGroupId.id, dataNodeLocationSet))));
                this.interruptTask();
            }
        };
        regionTask.execute();
        if (this.isFailed()) {
            return;
        }
        for (TCheckTimeSeriesExistenceResp resp : respList) {
            if (!resp.isExists()) continue;
            this.setFailure(new ProcedureException((Throwable)new TemplateImcompatibeException(this.templateName, path)));
        }
        this.setNextState(SetTemplateState.COMMIT_SET);
    }

    private void commitSetTemplate(ConfigNodeProcedureEnv env) {
        CommitSetSchemaTemplatePlan commitSetSchemaTemplatePlan = new CommitSetSchemaTemplatePlan(this.templateName, this.templateSetPath);
        TSStatus status = env.getConfigManager().getConsensusManager().write(commitSetSchemaTemplatePlan).getStatus();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(SetTemplateState.COMMIT_RELEASE);
        } else {
            LOGGER.warn("Failed to commit set template {} on path {} due to {}", new Object[]{this.templateName, this.templateSetPath, status.getMessage()});
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    private void commitReleaseTemplate(ConfigNodeProcedureEnv env) {
        Template template = this.getTemplate(env);
        if (template == null) {
            return;
        }
        TUpdateTemplateReq req = new TUpdateTemplateReq();
        req.setType(TemplateInternalRPCUpdateType.COMMIT_TEMPLATE_SET_INFO.toByte());
        req.setTemplateInfo(TemplateInternalRPCUtil.generateAddTemplateSetInfoBytes((Template)template, (String)this.templateSetPath));
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.UPDATE_TEMPLATE, req, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (Map.Entry entry : statusMap.entrySet()) {
            if (((TSStatus)entry.getValue()).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.warn("Failed to sync template {} commit-set info on path {} to DataNode {}", new Object[]{this.templateName, this.templateSetPath, dataNodeLocationMap.get(entry.getKey())});
            this.setFailure(new ProcedureException(new MetadataException(String.format("Failed to set schema template %s on path %s because there's failure on DataNode %s", this.templateName, this.templateSetPath, dataNodeLocationMap.get(entry.getKey())))));
            return;
        }
    }

    private void submitTemplateMaintainTask(TDataNodeLocation dataNodeLocation) {
    }

    @Override
    protected boolean isRollbackSupported(SetTemplateState setTemplateState) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, SetTemplateState state) throws IOException, InterruptedException, ProcedureException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case PRE_SET: {
                    LOGGER.info("Start rollback pre set schema template {} on path {}", (Object)this.templateName, (Object)this.templateSetPath);
                    this.rollbackPreSet(env);
                    return;
                }
                case PRE_RELEASE: {
                    LOGGER.info("Start rollback pre release schema template {} on path {}", (Object)this.templateName, (Object)this.templateSetPath);
                    this.rollbackPreRelease(env);
                    return;
                }
                case COMMIT_SET: {
                    LOGGER.info("Start rollback commit set schema template {} on path {}", (Object)this.templateName, (Object)this.templateSetPath);
                    this.rollbackCommitSet(env);
                    return;
                }
            }
            return;
        }
        finally {
            LOGGER.info("Rollback SetTemplate-{} costs {}ms.", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void rollbackPreSet(ConfigNodeProcedureEnv env) {
        PreSetSchemaTemplatePlan preSetSchemaTemplatePlan = new PreSetSchemaTemplatePlan(this.templateName, this.templateSetPath, true);
        TSStatus status = env.getConfigManager().getConsensusManager().write(preSetSchemaTemplatePlan).getStatus();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to rollback pre set template {} on path {} due to {}", new Object[]{this.templateName, this.templateSetPath, status.getMessage()});
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    private void rollbackPreRelease(ConfigNodeProcedureEnv env) {
        Template template = this.getTemplate(env);
        if (template == null) {
            return;
        }
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        TUpdateTemplateReq invalidateTemplateSetInfoReq = new TUpdateTemplateReq();
        invalidateTemplateSetInfoReq.setType(TemplateInternalRPCUpdateType.INVALIDATE_TEMPLATE_SET_INFO.toByte());
        invalidateTemplateSetInfoReq.setTemplateInfo(TemplateInternalRPCUtil.generateInvalidateTemplateSetInfoBytes((int)template.getId(), (String)this.templateSetPath));
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.UPDATE_TEMPLATE, invalidateTemplateSetInfoReq, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (Map.Entry entry : statusMap.entrySet()) {
            if (((TSStatus)entry.getValue()).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to rollback pre release template info of template {} set on path {} on DataNode {}", new Object[]{template.getName(), this.templateSetPath, dataNodeLocationMap.get(entry.getKey())});
            this.setFailure(new ProcedureException(new MetadataException("Rollback pre release template failed")));
        }
    }

    private void rollbackCommitSet(ConfigNodeProcedureEnv env) {
        CommitSetSchemaTemplatePlan commitSetSchemaTemplatePlan = new CommitSetSchemaTemplatePlan(this.templateName, this.templateSetPath, true);
        TSStatus status = env.getConfigManager().getConsensusManager().write(commitSetSchemaTemplatePlan).getStatus();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to rollback commit set template {} on path {} due to {}", new Object[]{this.templateName, this.templateSetPath, status.getMessage()});
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    @Override
    protected SetTemplateState getState(int stateId) {
        return SetTemplateState.values()[stateId];
    }

    @Override
    protected int getStateId(SetTemplateState state) {
        return state.ordinal();
    }

    @Override
    protected SetTemplateState getInitialState() {
        return SetTemplateState.VALIDATE_TEMPLATE_EXISTENCE;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getTemplateSetPath() {
        return this.templateSetPath;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.SET_TEMPLATE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.queryId, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.templateName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.templateSetPath, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.queryId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.templateName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.templateSetPath = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetTemplateProcedure that = (SetTemplateProcedure)o;
        return Objects.equals(this.templateName, that.templateName) && Objects.equals(this.templateSetPath, that.templateSetPath);
    }

    public int hashCode() {
        return Objects.hash(this.templateName, this.templateSetPath);
    }
}

