/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionTaskExecutor;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.DeleteTimeSeriesState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.mpp.rpc.thrift.TConstructSchemaBlackListReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteDataForDeleteSchemaReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateMatchedSchemaCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TRollbackSchemaBlackListReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTimeSeriesProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, DeleteTimeSeriesState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteTimeSeriesProcedure.class);
    private String queryId;
    private PathPatternTree patternTree;
    private transient ByteBuffer patternTreeBytes;
    private transient String requestMessage;

    public DeleteTimeSeriesProcedure() {
    }

    public DeleteTimeSeriesProcedure(String queryId, PathPatternTree patternTree) {
        this.queryId = queryId;
        this.setPatternTree(patternTree);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DeleteTimeSeriesState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long constructBlackList(ConfigNodeProcedureEnv env) {
        Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup = env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree);
        if (targetSchemaRegionGroup.isEmpty()) {
            return 0L;
        }
        final ArrayList successResult = new ArrayList();
        DeleteTimeSeriesRegionTaskExecutor<TConstructSchemaBlackListReq> constructBlackListTask = new DeleteTimeSeriesRegionTaskExecutor<TConstructSchemaBlackListReq>("construct schema black list", env, targetSchemaRegionGroup, DataNodeRequestType.CONSTRUCT_SCHEMA_BLACK_LIST, (dataNodeLocation, consensusGroupIdList) -> new TConstructSchemaBlackListReq(consensusGroupIdList, this.patternTreeBytes)){

            @Override
            protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TSStatus response) {
                ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
                if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    successResult.add(response);
                } else if (response.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    List subStatusList = response.getSubStatus();
                    for (int i = 0; i < subStatusList.size(); ++i) {
                        if (((TSStatus)subStatusList.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            successResult.add((TSStatus)subStatusList.get(i));
                            continue;
                        }
                        failedRegionList.add(consensusGroupIdList.get(i));
                    }
                } else {
                    failedRegionList.addAll(consensusGroupIdList);
                }
                return failedRegionList;
            }
        };
        constructBlackListTask.execute();
        if (this.isFailed()) {
            return 0L;
        }
        long preDeletedNum = 0L;
        for (TSStatus resp : successResult) {
            preDeletedNum += Long.parseLong(resp.getMessage());
        }
        return preDeletedNum;
    }

    private void invalidateCache(ConfigNodeProcedureEnv env) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.INVALIDATE_MATCHED_SCHEMA_CACHE, new TInvalidateMatchedSchemaCacheReq(this.patternTreeBytes), dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (TSStatus status : statusMap.values()) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to invalidate schema cache of timeseries {}", (Object)this.requestMessage);
            this.setFailure(new ProcedureException(new MetadataException("Invalidate schema cache failed")));
            return;
        }
        this.setNextState(DeleteTimeSeriesState.DELETE_DATA);
    }

    private void deleteData(ConfigNodeProcedureEnv env) {
        this.deleteDataWithRawPathPattern(env);
    }

    private void deleteDataWithRawPathPattern(ConfigNodeProcedureEnv env) {
        this.executeDeleteData(env, this.patternTree);
        if (this.isFailed()) {
            return;
        }
        this.setNextState(DeleteTimeSeriesState.DELETE_TIMESERIES_SCHEMA);
    }

    private void executeDeleteData(ConfigNodeProcedureEnv env, PathPatternTree patternTree) {
        Map<TConsensusGroupId, TRegionReplicaSet> relatedDataRegionGroup = env.getConfigManager().getRelatedDataRegionGroup(patternTree);
        if (relatedDataRegionGroup.isEmpty()) {
            return;
        }
        DeleteTimeSeriesRegionTaskExecutor<TDeleteDataForDeleteSchemaReq> deleteDataTask = new DeleteTimeSeriesRegionTaskExecutor<TDeleteDataForDeleteSchemaReq>("delete data", env, relatedDataRegionGroup, true, DataNodeRequestType.DELETE_DATA_FOR_DELETE_SCHEMA, (dataNodeLocation, consensusGroupIdList) -> new TDeleteDataForDeleteSchemaReq(new ArrayList(consensusGroupIdList), this.preparePatternTreeBytesData(patternTree)));
        deleteDataTask.execute();
    }

    private void deleteTimeSeriesSchema(ConfigNodeProcedureEnv env) {
        DeleteTimeSeriesRegionTaskExecutor<TDeleteTimeSeriesReq> deleteTimeSeriesTask = new DeleteTimeSeriesRegionTaskExecutor<TDeleteTimeSeriesReq>("delete timeseries schema", env, env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree), DataNodeRequestType.DELETE_TIMESERIES, (dataNodeLocation, consensusGroupIdList) -> new TDeleteTimeSeriesReq(consensusGroupIdList, this.patternTreeBytes));
        deleteTimeSeriesTask.execute();
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, DeleteTimeSeriesState deleteTimeSeriesState) throws IOException, InterruptedException, ProcedureException {
        DeleteTimeSeriesRegionTaskExecutor<TRollbackSchemaBlackListReq> rollbackStateTask = new DeleteTimeSeriesRegionTaskExecutor<TRollbackSchemaBlackListReq>("roll back schema black list", env, env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree), DataNodeRequestType.ROLLBACK_SCHEMA_BLACK_LIST, (dataNodeLocation, consensusGroupIdList) -> new TRollbackSchemaBlackListReq(consensusGroupIdList, this.patternTreeBytes));
        rollbackStateTask.execute();
    }

    @Override
    protected boolean isRollbackSupported(DeleteTimeSeriesState deleteTimeSeriesState) {
        return true;
    }

    @Override
    protected DeleteTimeSeriesState getState(int stateId) {
        return DeleteTimeSeriesState.values()[stateId];
    }

    @Override
    protected int getStateId(DeleteTimeSeriesState deleteTimeSeriesState) {
        return deleteTimeSeriesState.ordinal();
    }

    @Override
    protected DeleteTimeSeriesState getInitialState() {
        return DeleteTimeSeriesState.CONSTRUCT_BLACK_LIST;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public PathPatternTree getPatternTree() {
        return this.patternTree;
    }

    public void setPatternTree(PathPatternTree patternTree) {
        this.patternTree = patternTree;
        this.requestMessage = patternTree.getAllPathPatterns().toString();
        this.patternTreeBytes = this.preparePatternTreeBytesData(patternTree);
    }

    private ByteBuffer preparePatternTreeBytesData(PathPatternTree patternTree) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.DELETE_TIMESERIES_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.queryId, (OutputStream)stream);
        this.patternTree.serialize(stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.queryId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.setPatternTree(PathPatternTree.deserialize((ByteBuffer)byteBuffer));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteTimeSeriesProcedure that = (DeleteTimeSeriesProcedure)o;
        return this.getProcId() == that.getProcId() && this.getState() == that.getState() && this.patternTree.equals(that.patternTree);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getProcId(), this.getState(), this.patternTree});
    }

    private class DeleteTimeSeriesRegionTaskExecutor<Q>
    extends DataNodeRegionTaskExecutor<Q, TSStatus> {
        private final String taskName;

        DeleteTimeSeriesRegionTaskExecutor(String taskName, ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup, DataNodeRequestType dataNodeRequestType, BiFunction<TDataNodeLocation, List<TConsensusGroupId>, Q> dataNodeRequestGenerator) {
            super(env, targetSchemaRegionGroup, false, dataNodeRequestType, dataNodeRequestGenerator);
            this.taskName = taskName;
        }

        DeleteTimeSeriesRegionTaskExecutor(String taskName, ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup, boolean executeOnAllReplicaset, DataNodeRequestType dataNodeRequestType, BiFunction<TDataNodeLocation, List<TConsensusGroupId>, Q> dataNodeRequestGenerator) {
            super(env, targetSchemaRegionGroup, executeOnAllReplicaset, dataNodeRequestType, dataNodeRequestGenerator);
            this.taskName = taskName;
        }

        @Override
        protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TSStatus response) {
            ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
            if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return failedRegionList;
            }
            if (response.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                List subStatus = response.getSubStatus();
                for (int i = 0; i < subStatus.size(); ++i) {
                    if (((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    failedRegionList.add(consensusGroupIdList.get(i));
                }
            } else {
                failedRegionList.addAll(consensusGroupIdList);
            }
            return failedRegionList;
        }

        @Override
        protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
            DeleteTimeSeriesProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("Delete timeseries %s failed when [%s] because all replicaset of schemaRegion %s failed. %s", DeleteTimeSeriesProcedure.this.requestMessage, this.taskName, consensusGroupId.id, dataNodeLocationSet))));
            this.interruptTask();
        }
    }
}

