/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.task;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.SetPipeStatusPlanV2;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.pipe.AbstractOperatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartPipeProcedureV2
extends AbstractOperatePipeProcedureV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartPipeProcedureV2.class);
    private String pipeName;

    public StartPipeProcedureV2() {
    }

    public StartPipeProcedureV2(String pipeName) throws PipeException {
        this.pipeName = pipeName;
    }

    @Override
    protected PipeTaskOperation getOperation() {
        return PipeTaskOperation.START_PIPE;
    }

    @Override
    protected void executeFromValidateTask(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("StartPipeProcedureV2: executeFromValidateTask({})", (Object)this.pipeName);
        env.getConfigManager().getPipeManager().getPipeTaskCoordinator().getPipeTaskInfo().checkBeforeStartPipe(this.pipeName);
    }

    @Override
    protected void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("StartPipeProcedureV2: executeFromCalculateInfoForTask({})", (Object)this.pipeName);
    }

    @Override
    protected void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("StartPipeProcedureV2: executeFromWriteConfigNodeConsensus({})", (Object)this.pipeName);
        ConsensusWriteResponse response = env.getConfigManager().getConsensusManager().write(new SetPipeStatusPlanV2(this.pipeName, PipeStatus.RUNNING));
        if (!response.isSuccessful()) {
            throw new PipeException(response.getErrorMessage());
        }
    }

    @Override
    protected void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws PipeException, IOException {
        LOGGER.info("StartPipeProcedureV2: executeFromOperateOnDataNodes({})", (Object)this.pipeName);
        TSStatus result = this.pushPipeMetaToDataNodes(env);
        if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Failed to start pipe %s on data nodes. Failures: %s", this.pipeName, result.getMessage()));
        }
    }

    @Override
    protected void rollbackFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("StartPipeProcedureV2: rollbackFromValidateTask({})", (Object)this.pipeName);
    }

    @Override
    protected void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("StartPipeProcedureV2: rollbackFromCalculateInfoForTask({})", (Object)this.pipeName);
    }

    @Override
    protected void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        LOGGER.info("StartPipeProcedureV2: rollbackFromWriteConfigNodeConsensus({})", (Object)this.pipeName);
        ConsensusWriteResponse response = env.getConfigManager().getConsensusManager().write(new SetPipeStatusPlanV2(this.pipeName, PipeStatus.STOPPED));
        if (!response.isSuccessful()) {
            throw new PipeException(response.getErrorMessage());
        }
    }

    @Override
    protected void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws PipeException, IOException {
        LOGGER.info("StartPipeProcedureV2: rollbackFromOperateOnDataNodes({})", (Object)this.pipeName);
        TSStatus result = this.pushPipeMetaToDataNodes(env);
        if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Failed to rollback start pipe %s on data nodes. Failures: %s", this.pipeName, result.getMessage()));
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.START_PIPE_PROCEDURE_V2.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.pipeName, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.pipeName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartPipeProcedureV2 that = (StartPipeProcedureV2)o;
        return this.pipeName.equals(that.pipeName);
    }

    public int hashCode() {
        return this.pipeName.hashCode();
    }
}

