/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.task;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.DropPipePlanV2;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.pipe.AbstractOperatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropPipeProcedureV2
extends AbstractOperatePipeProcedureV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropPipeProcedureV2.class);
    private String pipeName;

    public DropPipeProcedureV2() {
    }

    public DropPipeProcedureV2(String pipeName) throws PipeException {
        this.pipeName = pipeName;
    }

    @Override
    protected PipeTaskOperation getOperation() {
        return PipeTaskOperation.DROP_PIPE;
    }

    @Override
    protected void executeFromValidateTask(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("DropPipeProcedureV2: executeFromValidateTask({})", (Object)this.pipeName);
        env.getConfigManager().getPipeManager().getPipeTaskCoordinator().getPipeTaskInfo().checkBeforeDropPipe(this.pipeName);
    }

    @Override
    protected void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("DropPipeProcedureV2: executeFromCalculateInfoForTask({})", (Object)this.pipeName);
    }

    @Override
    protected void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("DropPipeProcedureV2: executeFromWriteConfigNodeConsensus({})", (Object)this.pipeName);
        ConsensusWriteResponse response = env.getConfigManager().getConsensusManager().write(new DropPipePlanV2(this.pipeName));
        if (!response.isSuccessful()) {
            throw new PipeException(response.getErrorMessage());
        }
    }

    @Override
    protected void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws PipeException, IOException {
        LOGGER.info("DropPipeProcedureV2: executeFromOperateOnDataNodes({})", (Object)this.pipeName);
        TSStatus result = this.pushPipeMetaToDataNodes(env);
        if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Failed to drop pipe %s on data nodes. Failures: %s", this.pipeName, result.getMessage()));
        }
    }

    @Override
    protected void rollbackFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipeProcedureV2: rollbackFromValidateTask({})", (Object)this.pipeName);
    }

    @Override
    protected void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipeProcedureV2: rollbackFromCalculateInfoForTask({})", (Object)this.pipeName);
    }

    @Override
    protected void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipeProcedureV2: rollbackFromWriteConfigNodeConsensus({})", (Object)this.pipeName);
    }

    @Override
    protected void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropPipeProcedureV2: rollbackFromOperateOnDataNodes({})", (Object)this.pipeName);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.DROP_PIPE_PROCEDURE_V2.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.pipeName, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.pipeName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropPipeProcedureV2 that = (DropPipeProcedureV2)o;
        return this.pipeName.equals(that.pipeName);
    }

    public int hashCode() {
        return this.pipeName.hashCode();
    }
}

