/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.pipe;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.persistence.pipe.PipePluginInfo;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;

public class PipeInfo
implements SnapshotProcessor {
    private final PipePluginInfo pipePluginInfo = new PipePluginInfo();
    private final PipeTaskInfo pipeTaskInfo = new PipeTaskInfo();

    public PipePluginInfo getPipePluginInfo() {
        return this.pipePluginInfo;
    }

    public PipeTaskInfo getPipeTaskInfo() {
        return this.pipeTaskInfo;
    }

    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        this.pipeTaskInfo.acquirePipeTaskInfoLock();
        this.pipePluginInfo.acquirePipePluginInfoLock();
        try {
            boolean bl = this.pipeTaskInfo.processTakeSnapshot(snapshotDir) && this.pipePluginInfo.processTakeSnapshot(snapshotDir);
            return bl;
        }
        finally {
            this.pipePluginInfo.releasePipePluginInfoLock();
            this.pipeTaskInfo.releasePipeTaskInfoLock();
        }
    }

    public void processLoadSnapshot(File snapshotDir) throws IOException {
        this.pipeTaskInfo.acquirePipeTaskInfoLock();
        this.pipePluginInfo.acquirePipePluginInfoLock();
        try {
            this.pipeTaskInfo.processLoadSnapshot(snapshotDir);
            this.pipePluginInfo.processLoadSnapshot(snapshotDir);
        }
        finally {
            this.pipePluginInfo.releasePipePluginInfoLock();
            this.pipeTaskInfo.releasePipeTaskInfoLock();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeInfo pipeInfo = (PipeInfo)o;
        return Objects.equals(this.pipePluginInfo, pipeInfo.pipePluginInfo) && Objects.equals(this.pipeTaskInfo, pipeInfo.pipeTaskInfo);
    }

    public int hashCode() {
        return Objects.hash(this.pipePluginInfo, this.pipeTaskInfo);
    }

    public String toString() {
        return "PipeInfo{pipePluginInfo=" + this.pipePluginInfo + ", pipeTaskInfo=" + this.pipeTaskInfo + '}';
    }
}

