/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.runtime;

import java.util.HashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.load.subscriber.IClusterStatusSubscriber;
import org.apache.iotdb.confignode.manager.load.subscriber.RouteChangeEvent;
import org.apache.iotdb.confignode.manager.load.subscriber.StatisticsChangeEvent;
import org.apache.iotdb.tsfile.utils.Pair;

public class PipeLeaderChangeHandler
implements IClusterStatusSubscriber {
    private final ConfigManager configManager;

    PipeLeaderChangeHandler(ConfigManager configManager) {
        this.configManager = configManager;
    }

    @Override
    public void onClusterStatisticsChanged(StatisticsChangeEvent event) {
    }

    @Override
    public void onRegionGroupLeaderChanged(RouteChangeEvent event) {
        if (this.configManager.getPipeManager().getPipeTaskCoordinator().getPipeTaskInfo().isEmpty()) {
            return;
        }
        HashMap dataRegionGroupToOldAndNewLeaderPairMap = new HashMap();
        event.getLeaderMap().forEach((regionGroupId, pair) -> {
            String databaseName;
            if (regionGroupId.getType().equals((Object)TConsensusGroupType.DataRegion) && (databaseName = this.configManager.getPartitionManager().getRegionStorageGroup((TConsensusGroupId)regionGroupId)) != null && !databaseName.equals("root.__system")) {
                int newLeaderDataNodeId;
                int oldLeaderDataNodeId = pair.left == null ? -1 : (Integer)pair.left;
                int n = newLeaderDataNodeId = pair.right == null ? -1 : (Integer)pair.right;
                if (oldLeaderDataNodeId != newLeaderDataNodeId) {
                    dataRegionGroupToOldAndNewLeaderPairMap.put(regionGroupId, new Pair((Object)oldLeaderDataNodeId, (Object)newLeaderDataNodeId));
                }
            }
        });
        if (dataRegionGroupToOldAndNewLeaderPairMap.isEmpty()) {
            return;
        }
        this.configManager.getPipeManager().getPipeRuntimeCoordinator().getProcedureSubmitter().submit(() -> this.configManager.getProcedureManager().pipeHandleLeaderChange(dataRegionGroupToOldAndNewLeaderPairMap));
    }
}

