/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.exception.NoAvailableRegionGroupException;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.balancer.PartitionBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.RegionBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.RouteBalancer;
import org.apache.iotdb.confignode.manager.load.cache.LoadCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.service.HeartbeatService;
import org.apache.iotdb.confignode.manager.load.service.StatisticsService;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;

public class LoadManager {
    private final IManager configManager;
    private final RegionBalancer regionBalancer;
    private final PartitionBalancer partitionBalancer;
    private final RouteBalancer routeBalancer;
    private final LoadCache loadCache;
    private final HeartbeatService heartbeatService;
    private final StatisticsService statisticsService;
    private final EventBus loadPublisher = new AsyncEventBus("Cluster-LoadPublisher-Thread", (Executor)Executors.newFixedThreadPool(5));

    public LoadManager(IManager configManager) {
        this.configManager = configManager;
        this.regionBalancer = new RegionBalancer(configManager);
        this.partitionBalancer = new PartitionBalancer(configManager);
        this.routeBalancer = new RouteBalancer(configManager);
        this.loadCache = new LoadCache();
        this.heartbeatService = new HeartbeatService(configManager, this.loadCache);
        this.statisticsService = new StatisticsService(configManager, this.routeBalancer, this.loadCache, this.loadPublisher);
        this.loadPublisher.register((Object)this.statisticsService);
        this.loadPublisher.register((Object)configManager.getPipeManager().getPipeRuntimeCoordinator());
    }

    public CreateRegionGroupsPlan allocateRegionGroups(Map<String, Integer> allotmentMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, DatabaseNotExistsException {
        return this.regionBalancer.genRegionGroupsAllocationPlan(allotmentMap, consensusGroupType);
    }

    public Map<String, SchemaPartitionTable> allocateSchemaPartition(Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap) throws NoAvailableRegionGroupException {
        return this.partitionBalancer.allocateSchemaPartition(unassignedSchemaPartitionSlotsMap);
    }

    public Map<String, DataPartitionTable> allocateDataPartition(Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> unassignedDataPartitionSlotsMap) throws NoAvailableRegionGroupException {
        return this.partitionBalancer.allocateDataPartition(unassignedDataPartitionSlotsMap);
    }

    public void broadcastLatestRegionRouteMap() {
        this.statisticsService.broadcastLatestRegionRouteMap();
    }

    public void startLoadServices() {
        this.loadCache.initHeartbeatCache(this.configManager);
        this.heartbeatService.startHeartbeatService();
        this.statisticsService.startLoadStatisticsService();
    }

    public void stopLoadServices() {
        this.heartbeatService.stopHeartbeatService();
        this.statisticsService.stopLoadStatisticsService();
        this.loadCache.clearHeartbeatCache();
    }

    public NodeStatus getNodeStatus(int nodeId) {
        return this.loadCache.getNodeStatus(nodeId);
    }

    public String getNodeStatusWithReason(int nodeId) {
        return this.loadCache.getNodeStatusWithReason(nodeId);
    }

    public Map<Integer, String> getNodeStatusWithReason() {
        return this.loadCache.getNodeStatusWithReason();
    }

    public List<Integer> filterConfigNodeThroughStatus(NodeStatus ... status) {
        return this.loadCache.filterConfigNodeThroughStatus(status);
    }

    public List<Integer> filterDataNodeThroughStatus(NodeStatus ... status) {
        return this.loadCache.filterDataNodeThroughStatus(status);
    }

    public double getFreeDiskSpace(int dataNodeId) {
        return this.loadCache.getFreeDiskSpace(dataNodeId);
    }

    public Map<Integer, Long> getAllDataNodeLoadScores() {
        return this.loadCache.getAllDataNodeLoadScores();
    }

    public int getLowestLoadDataNode() {
        return this.loadCache.getLowestLoadDataNode();
    }

    public int getLowestLoadDataNode(List<Integer> dataNodeIds) {
        return this.loadCache.getLowestLoadDataNode(dataNodeIds);
    }

    public void forceUpdateNodeCache(NodeType nodeType, int nodeId, NodeHeartbeatSample heartbeatSample) {
        this.loadCache.forceUpdateNodeCache(nodeType, nodeId, heartbeatSample);
    }

    public void removeNodeCache(int nodeId) {
        this.loadCache.removeNodeCache(nodeId);
    }

    public RegionStatus getRegionStatus(TConsensusGroupId consensusGroupId, int dataNodeId) {
        return this.loadCache.getRegionStatus(consensusGroupId, dataNodeId);
    }

    public RegionGroupStatus getRegionGroupStatus(TConsensusGroupId consensusGroupId) {
        return this.loadCache.getRegionGroupStatus(consensusGroupId);
    }

    public Map<TConsensusGroupId, RegionGroupStatus> getRegionGroupStatus(List<TConsensusGroupId> consensusGroupIds) {
        return this.loadCache.getRegionGroupStatus(consensusGroupIds);
    }

    public List<TConsensusGroupId> filterRegionGroupThroughStatus(RegionGroupStatus ... status) {
        return this.loadCache.filterRegionGroupThroughStatus(status);
    }

    public int countRegionWithSpecifiedStatus(TConsensusGroupType type, RegionStatus ... status) {
        return this.loadCache.countRegionWithSpecifiedStatus(type, status);
    }

    public void forceUpdateRegionGroupCache(TConsensusGroupId regionGroupId, Map<Integer, RegionHeartbeatSample> heartbeatSampleMap) {
        this.loadCache.forceUpdateRegionGroupCache(regionGroupId, heartbeatSampleMap);
    }

    public void removeRegionGroupCache(TConsensusGroupId consensusGroupId) {
        this.loadCache.removeRegionGroupCache(consensusGroupId);
    }

    public Map<TConsensusGroupId, Integer> getRegionLeaderMap() {
        return this.loadCache.getRegionLeaderMap();
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getRegionPriorityMap() {
        return this.loadCache.getRegionPriorityMap();
    }

    public int getRegionGroupLeaderCount(int dataNodeId, TConsensusGroupType type) {
        AtomicInteger result = new AtomicInteger(0);
        this.getRegionLeaderMap().forEach((consensusGroupId, leaderId) -> {
            if (dataNodeId == leaderId && type.equals((Object)consensusGroupId.getType())) {
                result.getAndIncrement();
            }
        });
        return result.get();
    }

    public void waitForLeaderElection(List<TConsensusGroupId> regionGroupIds) {
        this.loadCache.waitForLeaderElection(regionGroupIds);
    }

    public void forceUpdateRegionLeader(TConsensusGroupId regionGroupId, int leaderId) {
        this.loadCache.forceUpdateRegionLeader(regionGroupId, leaderId);
    }

    public void forceUpdateRegionPriority(TConsensusGroupId regionGroupId, TRegionReplicaSet regionPriority) {
        this.loadCache.forceUpdateRegionPriority(regionGroupId, regionPriority);
    }

    public void removeRegionRouteCache(TConsensusGroupId regionGroupId) {
        this.loadCache.removeRegionRouteCache(regionGroupId);
    }
}

