/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.pipe.plugin;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GetPipePluginJarPlan
extends ConfigPhysicalPlan {
    private List<String> jarNames;

    public GetPipePluginJarPlan() {
        super(ConfigPhysicalPlanType.GetPipePluginJar);
    }

    public GetPipePluginJarPlan(List<String> jarNames) {
        super(ConfigPhysicalPlanType.GetPipePluginJar);
        this.jarNames = jarNames;
    }

    public List<String> getJarNames() {
        return this.jarNames;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((int)this.jarNames.size(), (OutputStream)stream);
        for (String jarName : this.jarNames) {
            ReadWriteIOUtils.write((String)jarName, (OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.jarNames = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            this.jarNames.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        }
    }
}

