/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelReq;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ShowModelPlan
extends ConfigPhysicalPlan {
    private String modelId;

    public ShowModelPlan() {
        super(ConfigPhysicalPlanType.ShowModel);
    }

    public ShowModelPlan(TShowModelReq showModelReq) {
        super(ConfigPhysicalPlanType.ShowModel);
        if (showModelReq.isSetModelId()) {
            this.modelId = showModelReq.getModelId();
        }
    }

    public boolean isSetModelId() {
        return this.modelId != null;
    }

    public String getModelId() {
        return this.modelId;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((Boolean)(this.modelId != null ? 1 : 0), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.modelId, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        boolean isSetModelId = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        if (isSetModelId) {
            this.modelId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShowModelPlan that = (ShowModelPlan)o;
        return Objects.equals(this.modelId, that.modelId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modelId);
    }
}

