/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.heartbeat;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.load.cache.LoadCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.pipe.runtime.PipeRuntimeCoordinator;
import org.apache.iotdb.mpp.rpc.thrift.THeartbeatResp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.async.AsyncMethodCallback;

public class DataNodeHeartbeatHandler
implements AsyncMethodCallback<THeartbeatResp> {
    private final int nodeId;
    private final LoadCache loadCache;
    private final Map<Integer, Long> deviceNum;
    private final Map<Integer, Long> timeSeriesNum;
    private final Map<Integer, Long> regionDisk;
    private final Consumer<Map<Integer, Long>> schemaQuotaRespProcess;
    private final PipeRuntimeCoordinator pipeRuntimeCoordinator;

    public DataNodeHeartbeatHandler(int nodeId, LoadCache loadCache, Map<Integer, Long> deviceNum, Map<Integer, Long> timeSeriesNum, Map<Integer, Long> regionDisk, Consumer<Map<Integer, Long>> schemaQuotaRespProcess, PipeRuntimeCoordinator pipeRuntimeCoordinator) {
        this.nodeId = nodeId;
        this.loadCache = loadCache;
        this.deviceNum = deviceNum;
        this.timeSeriesNum = timeSeriesNum;
        this.regionDisk = regionDisk;
        this.schemaQuotaRespProcess = schemaQuotaRespProcess;
        this.pipeRuntimeCoordinator = pipeRuntimeCoordinator;
    }

    public void onComplete(THeartbeatResp heartbeatResp) {
        long receiveTime = System.currentTimeMillis();
        this.loadCache.cacheDataNodeHeartbeatSample(this.nodeId, new NodeHeartbeatSample(heartbeatResp, receiveTime));
        heartbeatResp.getJudgedLeaders().forEach((regionGroupId, isLeader) -> {
            this.loadCache.cacheRegionHeartbeatSample((TConsensusGroupId)regionGroupId, this.nodeId, new RegionHeartbeatSample(heartbeatResp.getHeartbeatTimestamp(), receiveTime, RegionStatus.parse((String)heartbeatResp.getStatus())));
            if (isLeader.booleanValue()) {
                this.loadCache.cacheLeaderSample((TConsensusGroupId)regionGroupId, (Pair<Long, Integer>)new Pair((Object)heartbeatResp.getHeartbeatTimestamp(), (Object)this.nodeId));
            }
        });
        if (heartbeatResp.getRegionDeviceNumMap() != null) {
            this.deviceNum.putAll(heartbeatResp.getRegionDeviceNumMap());
        }
        if (heartbeatResp.getRegionTimeSeriesNumMap() != null) {
            this.timeSeriesNum.putAll(heartbeatResp.getRegionTimeSeriesNumMap());
        }
        if (heartbeatResp.getRegionDisk() != null) {
            this.regionDisk.putAll(heartbeatResp.getRegionDisk());
        }
        if (heartbeatResp.getSchemaLimitLevel() != null) {
            switch (heartbeatResp.getSchemaLimitLevel()) {
                case DEVICE: {
                    this.schemaQuotaRespProcess.accept(heartbeatResp.getRegionDeviceNumMap());
                    break;
                }
                case TIMESERIES: {
                    this.schemaQuotaRespProcess.accept(heartbeatResp.getRegionTimeSeriesNumMap());
                }
            }
        }
        if (heartbeatResp.getPipeMetaList() != null) {
            this.pipeRuntimeCoordinator.parseHeartbeat(this.nodeId, heartbeatResp.getPipeMetaList());
        }
    }

    public void onError(Exception e) {
    }
}

