/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.trigger;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TriggerInformation {
    private PartialPath pathPattern;
    private String triggerName;
    private String className;
    private boolean isUsingURI;
    private String jarName;
    private Map<String, String> attributes;
    private TriggerEvent event;
    private TTriggerState triggerState;
    private boolean isStateful;
    private TDataNodeLocation dataNodeLocation;
    private FailureStrategy failureStrategy;
    private String jarFileMD5;

    public TriggerInformation() {
    }

    public TriggerInformation(PartialPath pathPattern, String triggerName, String className, boolean isUsingURI, String jarName, Map<String, String> attributes, TriggerEvent event, TTriggerState triggerState, boolean isStateful, TDataNodeLocation dataNodeLocation, FailureStrategy failureStrategy, String jarFileMD5) {
        this.pathPattern = pathPattern;
        this.triggerName = triggerName;
        this.className = className;
        this.isUsingURI = isUsingURI;
        this.jarName = jarName;
        this.attributes = attributes;
        this.event = event;
        this.triggerState = triggerState;
        this.isStateful = isStateful;
        this.dataNodeLocation = dataNodeLocation;
        this.failureStrategy = failureStrategy;
        this.jarFileMD5 = jarFileMD5;
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(DataOutputStream outputStream) throws IOException {
        this.pathPattern.serialize(outputStream);
        ReadWriteIOUtils.write((String)this.triggerName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.className, (OutputStream)outputStream);
        ReadWriteIOUtils.write((Boolean)this.isUsingURI, (OutputStream)outputStream);
        if (this.isUsingURI) {
            ReadWriteIOUtils.write((String)this.jarName, (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)this.jarFileMD5, (OutputStream)outputStream);
        }
        ReadWriteIOUtils.write(this.attributes, (OutputStream)outputStream);
        ReadWriteIOUtils.write((byte)this.event.getId(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.triggerState.getValue(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((Boolean)this.isStateful, (OutputStream)outputStream);
        if (this.isStateful) {
            ThriftCommonsSerDeUtils.serializeTDataNodeLocation(this.dataNodeLocation, outputStream);
        }
        ReadWriteIOUtils.write((int)this.failureStrategy.getId(), (OutputStream)outputStream);
    }

    public static TriggerInformation deserialize(ByteBuffer byteBuffer) {
        boolean isStateful;
        TriggerInformation triggerInformation = new TriggerInformation();
        triggerInformation.pathPattern = (PartialPath)PathDeserializeUtil.deserialize(byteBuffer);
        triggerInformation.triggerName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        triggerInformation.className = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        triggerInformation.isUsingURI = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (triggerInformation.isUsingURI) {
            triggerInformation.jarName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            triggerInformation.jarFileMD5 = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        }
        triggerInformation.attributes = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
        triggerInformation.event = TriggerEvent.construct((byte)ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer));
        triggerInformation.triggerState = TTriggerState.findByValue((int)ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        triggerInformation.isStateful = isStateful = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (isStateful) {
            triggerInformation.dataNodeLocation = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation(byteBuffer);
        }
        triggerInformation.failureStrategy = FailureStrategy.construct((int)ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        return triggerInformation;
    }

    public static TriggerInformation deserialize(InputStream inputStream) throws IOException {
        return TriggerInformation.deserialize(ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)inputStream)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerInformation that = (TriggerInformation)o;
        return Objects.equals(this.triggerName, that.triggerName) && Objects.equals(this.pathPattern, that.pathPattern) && this.isStateful == that.isStateful && Objects.equals(this.className, that.className) && Objects.equals(this.jarName, that.jarName) && Objects.equals(this.attributes, that.attributes) && this.event == that.event && this.triggerState == that.triggerState && (!this.isStateful() || Objects.equals(this.dataNodeLocation, that.dataNodeLocation)) && Objects.equals(this.jarFileMD5, that.jarFileMD5);
    }

    public int hashCode() {
        return Objects.hash(this.triggerName);
    }

    public PartialPath getPathPattern() {
        return this.pathPattern;
    }

    public void setPathPattern(PartialPath pathPattern) {
        this.pathPattern = pathPattern;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isUsingURI() {
        return this.isUsingURI;
    }

    public void setUsingURI(boolean usingURI) {
        this.isUsingURI = usingURI;
    }

    public TriggerEvent getEvent() {
        return this.event;
    }

    public void setEvent(TriggerEvent event) {
        this.event = event;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getJarName() {
        return this.jarName;
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public TTriggerState getTriggerState() {
        return this.triggerState;
    }

    public void setTriggerState(TTriggerState triggerState) {
        this.triggerState = triggerState;
    }

    public boolean isStateful() {
        return this.isStateful;
    }

    public void setStateful(boolean stateful) {
        this.isStateful = stateful;
    }

    public TDataNodeLocation getDataNodeLocation() {
        return this.dataNodeLocation;
    }

    public void setDataNodeLocation(TDataNodeLocation dataNodeLocation) {
        this.dataNodeLocation = dataNodeLocation;
    }

    public FailureStrategy getFailureStrategy() {
        return this.failureStrategy;
    }

    public void setFailureStrategy(FailureStrategy failureStrategy) {
        this.failureStrategy = failureStrategy;
    }

    public String getJarFileMD5() {
        return this.jarFileMD5;
    }

    public void setJarFileMD5(String jarFileMD5) {
        this.jarFileMD5 = jarFileMD5;
    }
}

