/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.task.meta;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeMetaKeeper {
    protected final Map<String, PipeMeta> pipeNameToPipeMetaMap = new ConcurrentHashMap<String, PipeMeta>();

    public void addPipeMeta(String pipeName, PipeMeta pipeMeta) {
        this.pipeNameToPipeMetaMap.put(pipeName, pipeMeta);
    }

    public PipeMeta getPipeMeta(String pipeName) {
        return this.pipeNameToPipeMetaMap.get(pipeName);
    }

    public void removePipeMeta(String pipeName) {
        this.pipeNameToPipeMetaMap.remove(pipeName);
    }

    public boolean containsPipeMeta(String pipeName) {
        return this.pipeNameToPipeMetaMap.containsKey(pipeName);
    }

    public Iterable<PipeMeta> getPipeMetaList() {
        return this.pipeNameToPipeMetaMap.values();
    }

    public void clear() {
        this.pipeNameToPipeMetaMap.clear();
    }

    public boolean isEmpty() {
        return this.pipeNameToPipeMetaMap.isEmpty();
    }

    public void processTakeSnapshot(FileOutputStream fileOutputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.pipeNameToPipeMetaMap.size(), (OutputStream)fileOutputStream);
        for (Map.Entry<String, PipeMeta> entry : this.pipeNameToPipeMetaMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)fileOutputStream);
            entry.getValue().serialize(fileOutputStream);
        }
    }

    public void processLoadSnapshot(FileInputStream fileInputStream) throws IOException {
        this.clear();
        int size = ReadWriteIOUtils.readInt((InputStream)fileInputStream);
        for (int i = 0; i < size; ++i) {
            String pipeName = ReadWriteIOUtils.readString((InputStream)fileInputStream);
            this.pipeNameToPipeMetaMap.put(pipeName, PipeMeta.deserialize(fileInputStream));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeMetaKeeper that = (PipeMetaKeeper)o;
        return Objects.equals(this.pipeNameToPipeMetaMap, that.pipeNameToPipeMetaMap);
    }

    public int hashCode() {
        return Objects.hash(this.pipeNameToPipeMetaMap);
    }

    public String toString() {
        return "PipeMetaKeeper{pipeNameToPipeMetaMap=" + this.pipeNameToPipeMetaMap + '}';
    }
}

