/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.concurrent;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.iotdb.commons.concurrent.DataNodeThreadModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ThreadName {
    QUERY_WORKER("Query-Worker-Thread"),
    QUERY_SENTINEL("Query-Sentinel-Thread"),
    TIMED_QUERY_SQL_COUNT("Timed-Query-SQL-Count"),
    MPP_DATA_EXCHANGE_TASK_EXECUTOR("MPP-Data-Exchange-Task-Executors"),
    FRAGMENT_INSTANCE_MANAGEMENT("Fragment-Instance-Management"),
    FRAGMENT_INSTANCE_NOTIFICATION("Fragment-Instance-Notification"),
    DATANODE_INTERNAL_RPC_SERVICE("DataNodeInternalRPC-Service"),
    DATANODE_INTERNAL_RPC_PROCESSOR("DataNodeInternalRPC-Processor"),
    DRIVER_TASK_SCHEDULER_NOTIFICATION("Driver-Task-Scheduler-Notification"),
    MPP_COORDINATOR_SCHEDULED_EXECUTOR("MPP-Coordinator-Scheduled-Executor"),
    ASYNC_DATANODE_CLIENT_POOL("AsyncDataNodeInternalServiceClientPool"),
    MPP_DATA_EXCHANGE_RPC_SERVICE("MPPDataExchangeRPC-Service"),
    MPP_DATA_EXCHANGE_RPC_PROCESSOR("MPPDataExchangeRPC-Processor"),
    MPP_COORDINATOR_EXECUTOR_POOL("MPP-Coordinator-Executor"),
    ASYNC_DATANODE_MPP_DATA_EXCHANGE_CLIENT_POOL("AsyncDataNodeMPPDataExchangeServiceClientPool"),
    COMPACTION_WORKER("Compaction-Worker"),
    COMPACTION_SUB_TASK("Compaction-Sub-Task"),
    COMPACTION_SCHEDULE("Compaction-Schedule"),
    WAL_SERIALIZE("WAL-Serialize"),
    WAL_SYNC("WAL-Sync"),
    WAL_DELETE("WAL-Delete"),
    WAL_RECOVER("WAL-Recover"),
    MPP_COORDINATOR_WRITE_EXECUTOR("MPP-Coordinator-Write-Executor"),
    FLUSH("Flush"),
    FLUSH_SUB_TASK("Flush-SubTask"),
    FLUSH_TASK_SUBMIT("FlushTask-Submit-Pool"),
    TIMED_FLUSH_SEQ_MEMTABLE("Timed-Flush-Seq-Memtable"),
    TIMED_FLUSH_UNSEQ_MEMTABLE("Timed-Flush-Unseq-Memtable"),
    SCHEMA_REGION_RELEASE_PROCESSOR("SchemaRegion-Release-Task-Processor"),
    SCHEMA_RELEASE_MONITOR("Schema-Release-Task-Monitor"),
    SCHEMA_REGION_FLUSH_PROCESSOR("SchemaRegion-Flush-Task-Processor"),
    SCHEMA_FLUSH_MONITOR("Schema-Flush-Task-Monitor"),
    CLIENT_RPC_SERVICE("ClientRPC-Service"),
    CLIENT_RPC_PROCESSOR("ClientRPC-Processor"),
    CONFIGNODE_RPC_SERVICE("ConfigNodeRPC-Service"),
    CONFIGNODE_RPC_PROCESSOR("ConfigNodeRPC-Processor"),
    ASYNC_CONFIGNODE_HEARTBEAT_CLIENT_POOL("AsyncConfigNodeHeartbeatServiceClientPool"),
    ASYNC_DATANODE_HEARTBEAT_CLIENT_POOL("AsyncDataNodeHeartbeatServiceClientPool"),
    ASYNC_CONFIGNODE_CLIENT_POOL("AsyncConfigNodeIServiceClientPool"),
    CQ_MANAGER("CQ-Scheduler"),
    IOT_CONSENSUS_RPC_SERVICE("IoTConsensusRPC-Service"),
    IOT_CONSENSUS_RPC_PROCESSOR("IoTConsensusRPC-Processor"),
    ASYNC_DATANODE_IOT_CONSENSUS_CLIENT_POOL("AsyncDataNodeIoTConsensusServiceClientPool"),
    LOG_DISPATCHER("LogDispatcher"),
    RAFT_SERVER_PROXY_EXECUTOR("\\d+-impl-thread"),
    RAFT_SERVER_EXECUTOR("\\d+-server-thread"),
    RAFT_SERVER_CLIENT_EXECUTOR("\\d+-client-thread"),
    SEGMENT_RAFT_WORKER("SegmentedRaftLogWorker"),
    STATE_MACHINE_UPDATER("StateMachineUpdater"),
    FOLLOWER_STATE("FollowerState"),
    LEADER_STATE_IMPL_PROCESSOR("LeaderStateImpl"),
    LEADER_ELECTION("LeaderElection"),
    LOG_APPENDER("GrpcLogAppender"),
    EVENT_PROCESSOR("EventProcessor"),
    RATIS_BG_DISK_GUARDIAN("ratis-bg-disk-guardian"),
    GRPC_DEFAULT_BOSS_ELG("grpc-default-boss-ELG"),
    GRPC_DEFAULT_EXECUTOR("grpc-default-executor"),
    GPRC_DEFAULT_WORKER_ELG("grpc-default-worker-ELG"),
    GROUP_MANAGEMENT("groupManagement"),
    PIPE_ASSIGNER_EXECUTOR_POOL("Pipe-Assigner-Executor-Pool"),
    PIPE_PROCESSOR_EXECUTOR_POOL("Pipe-Processor-Executor-Pool"),
    PIPE_CONNECTOR_EXECUTOR_POOL("Pipe-Connector-Executor-Pool"),
    PIPE_SUBTASK_CALLBACK_EXECUTOR_POOL("Pipe-SubTask-Callback-Executor-Pool"),
    PIPE_RUNTIME_META_SYNCER("Pipe-Runtime-Meta-Syncer"),
    PIPE_RUNTIME_HEARTBEAT("Pipe-Runtime-Heartbeat"),
    PIPE_RUNTIME_PROCEDURE_SUBMITTER("Pipe-Runtime-Procedure-Submitter"),
    PIPE_WAL_RESOURCE_TTL_CHECKER("Pipe-WAL-Resource-TTL-Checker"),
    WINDOW_EVALUATION_SERVICE("WindowEvaluationTaskPoolManager"),
    JVM_PAUSE_MONITOR("JvmPauseMonitor"),
    PARALLEL_GC("GC task thread"),
    G1_GC("GC Thread"),
    G1_MAIN_MARKER("G1 Main Marker"),
    G1_CONC("G1 Conc"),
    G1_REFINE("G1 Refine"),
    G1_YOUNG_REMSET_SAMPLING("G1 Young RemSet Sampling"),
    COMPILE("CompilerThread"),
    VM_PERIODIC_TASK("VM Periodic Task Thread"),
    VM_THREAD("VM Thread"),
    REFERENCE_HANDLER("Reference Handler"),
    FINALIZER("Finalizer"),
    SIGNAL_DISPATCHER("Signal Dispatcher"),
    DESTROY_JVM("DestroyJavaVM"),
    COMMON_CLEANER("Common-Cleaner"),
    LOG_BACK("logback"),
    SYSTEM_SCHEDULE_METRICS("SystemScheduleMetrics"),
    RESOURCE_CONTROL_DISK_STATISTIC("ResourceControl-DataRegionDiskStatistics"),
    PROMETHEUS_REACTOR_HTTP_NIO("reactor-http-nio"),
    PROMETHEUS_REACTOR_HTTP_EPOLL("reactor-http-epoll"),
    PROMETHEUS_BOUNDED_ELASTIC("boundedElastic-evictor"),
    FORK_JOIN_POOL("ForkJoinPool"),
    TIMER("timer"),
    TTL_CHECK("TTL-CHECK"),
    SETTLE("Settle"),
    INFLUXDB_RPC_SERVICE("InfluxdbRPC-Service"),
    INFLUXDB_RPC_PROCESSOR("InfluxdbRPC-Processor"),
    STORAGE_ENGINE_CACHED_POOL("StorageEngine"),
    MLNODE_RPC_SERVICE("MLNodeRpc-Service"),
    IOTDB_SHUTDOWN_HOOK("IoTDB-Shutdown-Hook"),
    STORAGE_ENGINE_RECOVER_TRIGGER("StorageEngine-RecoverTrigger"),
    UNKOWN("UNKNOWN");

    private static final Logger log;
    private final String name;
    private static Set<ThreadName> queryThreadNames;
    private static Set<ThreadName> mppThreadNames;
    private static Set<ThreadName> compactionThreadNames;
    private static Set<ThreadName> walThreadNames;
    private static Set<ThreadName> flushThreadNames;
    private static Set<ThreadName> schemaEngineThreadNames;
    private static Set<ThreadName> clientServiceThreadNames;
    private static Set<ThreadName> iotConsensusThrreadNames;
    private static Set<ThreadName> ratisThreadNames;
    private static Set<ThreadName> computeThreadNames;
    private static Set<ThreadName> jvmThreadNames;
    private static Set<ThreadName> metricsThreadNames;
    private static Set<ThreadName> systemThreadNames;
    private static Set<ThreadName> otherThreadNames;

    private ThreadName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static DataNodeThreadModule getModuleTheThreadBelongs(String givenThreadName) {
        Set[] threadNameSetList = new Set[]{queryThreadNames, mppThreadNames, compactionThreadNames, walThreadNames, flushThreadNames, schemaEngineThreadNames, clientServiceThreadNames, iotConsensusThrreadNames, ratisThreadNames, computeThreadNames, jvmThreadNames, metricsThreadNames, systemThreadNames, otherThreadNames};
        DataNodeThreadModule[] modules = new DataNodeThreadModule[]{DataNodeThreadModule.QUERY, DataNodeThreadModule.MPP, DataNodeThreadModule.COMPACTION, DataNodeThreadModule.WAL, DataNodeThreadModule.FLUSH, DataNodeThreadModule.SCHEMA_ENGINE, DataNodeThreadModule.CLIENT_SERVICE, DataNodeThreadModule.IOT_CONSENSUS, DataNodeThreadModule.RATIS_CONSENSUS, DataNodeThreadModule.COMPUTE, DataNodeThreadModule.JVM, DataNodeThreadModule.METRICS, DataNodeThreadModule.SYSTEM, DataNodeThreadModule.OTHER};
        int length = modules.length;
        for (int i = 0; i < length; ++i) {
            if (ThreadName.matchModuleWithThreadNames(threadNameSetList[i], modules[i], givenThreadName) == null) continue;
            return modules[i];
        }
        if (givenThreadName.contains(LOG_BACK.getName())) {
            return DataNodeThreadModule.LOG_BACK;
        }
        return DataNodeThreadModule.UNKNOWN;
    }

    private static DataNodeThreadModule matchModuleWithThreadNames(Set<ThreadName> threadNames, DataNodeThreadModule module, String givenThreadName) {
        for (ThreadName threadName : threadNames) {
            if (!(threadName.getName().contains("\\d") ? Pattern.compile(threadName.getName()).matcher(givenThreadName).find() : givenThreadName.contains(threadName.getName()))) continue;
            return module;
        }
        log.debug("The module for this thread is unknown: {}", (Object)givenThreadName);
        return null;
    }

    public static ThreadName getThreadPoolTheThreadBelongs(String givenThreadName) {
        ThreadName[] threadNames;
        for (ThreadName threadName : threadNames = ThreadName.values()) {
            String name = threadName.getName();
            if (!(name.contains("\\d") ? Pattern.compile(name).matcher(givenThreadName).find() : givenThreadName.contains(name))) continue;
            return threadName;
        }
        log.debug("Unknown thread name: {}", (Object)givenThreadName);
        return UNKOWN;
    }

    static {
        log = LoggerFactory.getLogger(ThreadName.class);
        queryThreadNames = new HashSet<ThreadName>(Arrays.asList(QUERY_WORKER, QUERY_SENTINEL, TIMED_QUERY_SQL_COUNT, MPP_DATA_EXCHANGE_TASK_EXECUTOR, FRAGMENT_INSTANCE_MANAGEMENT, FRAGMENT_INSTANCE_NOTIFICATION, DATANODE_INTERNAL_RPC_SERVICE, DATANODE_INTERNAL_RPC_PROCESSOR, DRIVER_TASK_SCHEDULER_NOTIFICATION));
        mppThreadNames = new HashSet<ThreadName>(Arrays.asList(MPP_COORDINATOR_SCHEDULED_EXECUTOR, ASYNC_DATANODE_CLIENT_POOL, MPP_COORDINATOR_WRITE_EXECUTOR, MPP_DATA_EXCHANGE_RPC_SERVICE, MPP_DATA_EXCHANGE_RPC_PROCESSOR, MPP_COORDINATOR_EXECUTOR_POOL, ASYNC_DATANODE_MPP_DATA_EXCHANGE_CLIENT_POOL));
        compactionThreadNames = new HashSet<ThreadName>(Arrays.asList(COMPACTION_WORKER, COMPACTION_SUB_TASK, COMPACTION_SCHEDULE));
        walThreadNames = new HashSet<ThreadName>(Arrays.asList(WAL_DELETE, WAL_SERIALIZE, WAL_SYNC, WAL_DELETE, WAL_RECOVER));
        flushThreadNames = new HashSet<ThreadName>(Arrays.asList(FLUSH, FLUSH_SUB_TASK, FLUSH_TASK_SUBMIT, TIMED_FLUSH_SEQ_MEMTABLE, TIMED_FLUSH_UNSEQ_MEMTABLE));
        schemaEngineThreadNames = new HashSet<ThreadName>(Arrays.asList(SCHEMA_REGION_FLUSH_PROCESSOR, SCHEMA_RELEASE_MONITOR, SCHEMA_REGION_RELEASE_PROCESSOR, SCHEMA_FLUSH_MONITOR));
        clientServiceThreadNames = new HashSet<ThreadName>(Arrays.asList(CLIENT_RPC_SERVICE, CLIENT_RPC_PROCESSOR));
        iotConsensusThrreadNames = new HashSet<ThreadName>(Arrays.asList(IOT_CONSENSUS_RPC_SERVICE, IOT_CONSENSUS_RPC_PROCESSOR, ASYNC_DATANODE_IOT_CONSENSUS_CLIENT_POOL, LOG_DISPATCHER));
        ratisThreadNames = new HashSet<ThreadName>(Arrays.asList(RAFT_SERVER_PROXY_EXECUTOR, RAFT_SERVER_EXECUTOR, RAFT_SERVER_CLIENT_EXECUTOR, SEGMENT_RAFT_WORKER, STATE_MACHINE_UPDATER, FOLLOWER_STATE, LEADER_STATE_IMPL_PROCESSOR, LEADER_ELECTION, LOG_APPENDER, EVENT_PROCESSOR, RATIS_BG_DISK_GUARDIAN, GRPC_DEFAULT_BOSS_ELG, GPRC_DEFAULT_WORKER_ELG, GRPC_DEFAULT_EXECUTOR, GROUP_MANAGEMENT));
        computeThreadNames = new HashSet<ThreadName>(Arrays.asList(PIPE_ASSIGNER_EXECUTOR_POOL, PIPE_PROCESSOR_EXECUTOR_POOL, PIPE_CONNECTOR_EXECUTOR_POOL, PIPE_SUBTASK_CALLBACK_EXECUTOR_POOL, PIPE_RUNTIME_META_SYNCER, PIPE_RUNTIME_PROCEDURE_SUBMITTER, PIPE_WAL_RESOURCE_TTL_CHECKER, WINDOW_EVALUATION_SERVICE));
        jvmThreadNames = new HashSet<ThreadName>(Arrays.asList(JVM_PAUSE_MONITOR, PARALLEL_GC, G1_GC, G1_MAIN_MARKER, G1_REFINE, G1_CONC, G1_YOUNG_REMSET_SAMPLING, COMPILE, VM_PERIODIC_TASK, VM_THREAD, REFERENCE_HANDLER, FINALIZER, SIGNAL_DISPATCHER, DESTROY_JVM, COMMON_CLEANER));
        metricsThreadNames = new HashSet<ThreadName>(Arrays.asList(SYSTEM_SCHEDULE_METRICS, RESOURCE_CONTROL_DISK_STATISTIC, PROMETHEUS_REACTOR_HTTP_NIO, PROMETHEUS_REACTOR_HTTP_EPOLL, PROMETHEUS_BOUNDED_ELASTIC));
        systemThreadNames = new HashSet<ThreadName>(Arrays.asList(FORK_JOIN_POOL, TIMER));
        otherThreadNames = new HashSet<ThreadName>(Arrays.asList(TTL_CHECK, SETTLE, INFLUXDB_RPC_SERVICE, INFLUXDB_RPC_PROCESSOR, STORAGE_ENGINE_CACHED_POOL, MLNODE_RPC_SERVICE));
    }
}

