/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class RatisMetricsManager {
    private final MetricService metricService = MetricService.getInstance();

    public void recordWriteLocallyCost(long costTimeInNanos, TConsensusGroupType consensusGroupType) {
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, consensusGroupType.toString() + "_" + Metric.RATIS_CONSENSUS_WRITE, MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), "writeLocally"});
    }

    public void recordWriteRemotelyCost(long costTimeInNanos, TConsensusGroupType consensusGroupType) {
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, consensusGroupType.toString() + "_" + Metric.RATIS_CONSENSUS_WRITE, MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), "writeRemotely"});
    }

    public void recordReadRequestCost(long costTimeInNanos, TConsensusGroupType consensusGroupType) {
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, consensusGroupType.toString() + "_" + Metric.RATIS_CONSENSUS_READ, MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), "submitReadRequest"});
    }

    public void recordWriteStateMachineCost(long costTimeInNanos, TConsensusGroupType consensusGroupType) {
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, consensusGroupType.toString() + "_" + Metric.RATIS_CONSENSUS_WRITE, MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), "writeStateMachine"});
    }

    public static RatisMetricsManager getInstance() {
        return RatisMetricsManagerHolder.INSTANCE;
    }

    private static class RatisMetricsManagerHolder {
        private static final RatisMetricsManager INSTANCE = new RatisMetricsManager();

        private RatisMetricsManagerHolder() {
        }
    }
}

