/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer.reporter;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.jmx.JmxMeterRegistry;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.micrometer.reporter.JmxConfig;
import org.apache.iotdb.metrics.reporter.JmxReporter;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrometerJmxReporter
implements JmxReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrometerJmxReporter.class);

    public boolean start() {
        try {
            Set meterRegistrySet = Metrics.globalRegistry.getRegistries().stream().filter(reporter -> reporter instanceof JmxMeterRegistry).collect(Collectors.toSet());
            if (meterRegistrySet.size() != 0) {
                LOGGER.warn("Micrometer JmxReporter already start!");
                return false;
            }
            Metrics.addRegistry((MeterRegistry)new JmxMeterRegistry((io.micrometer.jmx.JmxConfig)JmxConfig.DEFAULT, Clock.SYSTEM));
        }
        catch (Exception e) {
            LOGGER.warn("Micrometer JmxReporter failed to start, because ", (Throwable)e);
            return false;
        }
        LOGGER.info("Micrometer JmxReporter start!");
        return true;
    }

    public boolean stop() {
        try {
            Set meterRegistrySet = Metrics.globalRegistry.getRegistries().stream().filter(reporter -> reporter instanceof JmxMeterRegistry).collect(Collectors.toSet());
            for (MeterRegistry meterRegistry : meterRegistrySet) {
                if (meterRegistry.isClosed()) continue;
                ((JmxMeterRegistry)meterRegistry).stop();
                meterRegistry.close();
                Metrics.removeRegistry((MeterRegistry)meterRegistry);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Micrometer JmxReporter failed to stop, because ", (Throwable)e);
            return false;
        }
        LOGGER.info("Micrometer JmxReporter stop!");
        return true;
    }

    public ReporterType getReporterType() {
        return ReporterType.JMX;
    }

    public void setMetricManager(AbstractMetricManager metricManager) {
    }
}

