/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Vector;
import org.apache.iotdb.tsfile.encoding.bitpacking.LongPacker;
import org.apache.iotdb.tsfile.encoding.encoder.DoublePrecisionEncoderV2;
import org.apache.iotdb.tsfile.encoding.encoder.SprintzEncoder;
import org.apache.iotdb.tsfile.encoding.fire.LongFire;
import org.apache.iotdb.tsfile.exception.encoding.TsFileEncodingException;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class DoubleSprintzEncoder
extends SprintzEncoder {
    LongPacker packer;
    LongFire firePred;
    protected Vector<Double> values = new Vector();
    long[] convertBuffer;

    public DoubleSprintzEncoder() {
        this.firePred = new LongFire(3);
        this.convertBuffer = new long[this.Block_size];
    }

    @Override
    protected void reset() {
        super.reset();
        this.values.clear();
    }

    @Override
    public int getOneItemMaxSize() {
        return 1 + (1 + this.Block_size) * 8;
    }

    @Override
    public long getMaxByteSize() {
        return 1L + (long)(this.values.size() + 1) * 8L;
    }

    protected long predict(Double value, Double preVlaue) throws TsFileEncodingException {
        long pred;
        if (this.PredictMethod.equals("delta")) {
            pred = this.delta(value, preVlaue);
        } else if (this.PredictMethod.equals("fire")) {
            pred = this.fire(value, preVlaue);
        } else {
            throw new TsFileEncodingException("Config: Predict Method {} of SprintzEncoder is not supported.");
        }
        pred = pred <= 0L ? -2L * pred : 2L * pred - 1L;
        return pred;
    }

    @Override
    protected void bitPack() throws IOException {
        double preValue = this.values.get(0);
        this.values.remove(0);
        Vector<Long> convertBufferList = new Vector<Long>();
        for (long itemBuffer : this.convertBuffer) {
            convertBufferList.add(itemBuffer);
        }
        this.bitWidth = ReadWriteForEncodingUtils.getLongMaxBitWidth(convertBufferList);
        this.packer = new LongPacker(this.bitWidth);
        byte[] bytes = new byte[this.bitWidth];
        this.packer.pack8Values(this.convertBuffer, 0, bytes);
        ReadWriteForEncodingUtils.writeIntLittleEndianPaddedOnBitWidth(this.bitWidth, this.byteCache, 1);
        this.byteCache.write(ByteBuffer.allocate(8).putDouble(preValue).array());
        this.byteCache.write(bytes, 0, bytes.length);
    }

    protected long delta(Double value, Double preValue) {
        return Double.doubleToLongBits(value) - Double.doubleToLongBits(preValue);
    }

    protected long fire(Double value, Double preValue) {
        long prev = Double.doubleToLongBits(preValue);
        long val = Double.doubleToLongBits(value);
        long pred = this.firePred.predict(prev);
        long err = val - pred;
        this.firePred.train(prev, val, err);
        return err;
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        if (this.byteCache.size() > 0) {
            this.byteCache.writeTo(out);
        }
        if (!this.values.isEmpty()) {
            int size = this.values.size();
            ReadWriteForEncodingUtils.writeIntLittleEndianPaddedOnBitWidth(size |= 0x80, out, 1);
            DoublePrecisionEncoderV2 encoder = new DoublePrecisionEncoderV2();
            for (double val : this.values) {
                encoder.encode(val, out);
            }
            encoder.flush(out);
        }
        this.reset();
    }

    @Override
    public void encode(double value, ByteArrayOutputStream out) {
        if (!this.isFirstCached) {
            this.values.add(value);
            this.isFirstCached = true;
            return;
        }
        this.values.add(value);
        if (this.values.size() == this.Block_size + 1) {
            try {
                this.firePred.reset();
                for (int i = 1; i <= this.Block_size; ++i) {
                    this.convertBuffer[i - 1] = this.predict(this.values.get(i), this.values.get(i - 1));
                }
                this.bitPack();
                this.isFirstCached = false;
                this.values.clear();
                ++this.groupNum;
                if (this.groupNum == this.groupMax) {
                    this.flush(out);
                }
            }
            catch (IOException e) {
                logger.error("Error occured when encoding INT32 Type value with with Sprintz", (Throwable)e);
            }
        }
    }
}

