/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v2.file.footer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ChunkGroupFooterV2 {
    private ChunkGroupFooterV2() {
    }

    public static ChunkGroupHeader deserializeFrom(InputStream inputStream, boolean markerRead) throws IOException {
        byte marker;
        if (!markerRead && (marker = (byte)inputStream.read()) != 0) {
            MetaMarker.handleUnexpectedMarker(marker);
        }
        String deviceID = ReadWriteIOUtils.readString(inputStream);
        ReadWriteIOUtils.readLong(inputStream);
        ReadWriteIOUtils.readInt(inputStream);
        return new ChunkGroupHeader(deviceID);
    }

    public static ChunkGroupHeader deserializeFrom(TsFileInput input, long offset, boolean markerRead) throws IOException {
        long offsetVar = offset;
        if (!markerRead) {
            ++offsetVar;
        }
        ByteBuffer buffer = ByteBuffer.allocate(4);
        input.read(buffer, offsetVar);
        buffer.flip();
        int size = buffer.getInt();
        buffer = ByteBuffer.allocate(ChunkGroupFooterV2.getSerializedSize(size));
        ReadWriteIOUtils.readAsPossible(input, offsetVar += 4L, buffer);
        buffer.flip();
        String deviceID = ReadWriteIOUtils.readStringWithLength(buffer, size);
        ReadWriteIOUtils.readLong(buffer);
        ReadWriteIOUtils.readInt(buffer);
        return new ChunkGroupHeader(deviceID);
    }

    private static int getSerializedSize(int deviceIdLength) {
        return deviceIdLength + 8 + 4;
    }
}

