/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.logdispatcher;

import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.consensus.iot.logdispatcher.LogDispatcher;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class LogDispatcherThreadMetrics
implements IMetricSet {
    private final LogDispatcher.LogDispatcherThread logDispatcherThread;

    public LogDispatcherThreadMetrics(LogDispatcher.LogDispatcherThread logDispatcherThread) {
        this.logDispatcherThread = logDispatcherThread;
    }

    public void bindTo(AbstractMetricService metricService) {
        MetricService.getInstance().createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.logDispatcherThread, LogDispatcher.LogDispatcherThread::getCurrentSyncIndex, new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "currentSyncIndex"});
        MetricService.getInstance().createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.logDispatcherThread, x -> x.getSyncStatus().getPendingBatches().size(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "pipelineNum"});
        MetricService.getInstance().createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.logDispatcherThread, x -> x.getPendingEntriesSize() + x.getBufferRequestSize(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "cachedRequestInMemoryQueue"});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        MetricService.getInstance().remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "currentSyncIndex"});
        MetricService.getInstance().remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "pipelineNum"});
        MetricService.getInstance().remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "cachedRequestInMemoryQueue"});
    }

    private String formatName() {
        return String.format("logDispatcher-%s:%s", this.logDispatcherThread.getPeer().getEndpoint().getIp(), this.logDispatcherThread.getPeer().getEndpoint().getPort());
    }
}

