/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.settle;

import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSettleReq;
import org.apache.iotdb.mpp.rpc.thrift.IDataNodeRPCService;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.layered.TFramedTransport;

public class TsFileSettleByCompactionTool {
    private static final String HOST_ARGS = "h";
    private static final String HOST_NAME = "host";
    private static final String PORT_ARGS = "p";
    private static final String PORT_NAME = "port";
    private static final String FILE_PATH_ARGS = "f";
    private static final String FILE_PATH_NAME = "file paths";
    private static final String DEFAULT_HOST_VALUE = "127.0.0.1";
    private static final String DEFAULT_PORT_VALUE = "9003";

    public static void main(String[] args) throws TException {
        CommandLine commandLine;
        Options commandLineOptions = TsFileSettleByCompactionTool.createOptions();
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(commandLineOptions, args);
        }
        catch (ParseException e) {
            System.out.println("Parse command line args failed: " + e.getMessage());
            return;
        }
        String hostValue = TsFileSettleByCompactionTool.getArgOrDefault(commandLine, HOST_ARGS, DEFAULT_HOST_VALUE);
        String portValue = TsFileSettleByCompactionTool.getArgOrDefault(commandLine, PORT_ARGS, DEFAULT_PORT_VALUE);
        int port = Integer.parseInt(portValue);
        String[] filePaths = commandLine.getOptionValues(FILE_PATH_ARGS);
        TFramedTransport transport = new TFramedTransport((TTransport)new TSocket(hostValue, port));
        transport.open();
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        IDataNodeRPCService.Client.Factory clientFactory = new IDataNodeRPCService.Client.Factory();
        IDataNodeRPCService.Client client = clientFactory.getClient((TProtocol)protocol);
        TSettleReq tSettleReq = new TSettleReq();
        tSettleReq.setPaths(Arrays.asList(filePaths));
        TSStatus result = client.settle(tSettleReq);
        if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            System.out.println("Add Settle Compaction Task Successfully");
        } else {
            System.out.println("Add settle compaction task failed with status code: " + result);
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        Option host = Option.builder((String)HOST_ARGS).argName(HOST_NAME).hasArg().desc("Host Name (optional, default 127.0.0.1").build();
        options.addOption(host);
        Option port = Option.builder((String)PORT_ARGS).argName(PORT_NAME).hasArg().desc("Port (optional, default 9003)").build();
        options.addOption(port);
        Option filePaths = Option.builder((String)FILE_PATH_ARGS).argName(FILE_PATH_NAME).hasArgs().valueSeparator(' ').desc("File Paths (required)").required().build();
        options.addOption(filePaths);
        return options;
    }

    private static String getArgOrDefault(CommandLine commandLine, String arg, String defaultValue) {
        String value = commandLine.getOptionValue(arg);
        return value == null ? defaultValue : value;
    }
}

