/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.pipedata.queue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.sync.utils.SyncConstant;
import org.apache.iotdb.commons.sync.utils.SyncPathUtil;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.pipedata.TsFilePipeData;
import org.apache.iotdb.db.sync.pipedata.queue.PipeDataQueue;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedPipeDataQueue
implements PipeDataQueue {
    private static final Logger logger = LoggerFactory.getLogger(BufferedPipeDataQueue.class);
    private final String pipeLogDir;
    private long lastMaxSerialNumber;
    private BlockingDeque<PipeData> inputDeque;
    private BlockingDeque<Long> pipeLogStartNumber;
    private DataOutputStream outputStream;
    private long currentPipeLogSize;
    private final Object waitLock = new Object();
    private BlockingDeque<PipeData> outputDeque;
    private long pullSerialNumber;
    private long commitSerialNumber;
    private DataOutputStream commitLogWriter;
    private long currentCommitLogSize;

    public BufferedPipeDataQueue(String pipeLogDir) {
        this.pipeLogDir = pipeLogDir;
        this.lastMaxSerialNumber = 0L;
        this.pipeLogStartNumber = new LinkedBlockingDeque<Long>();
        this.outputDeque = new LinkedBlockingDeque<PipeData>();
        this.pullSerialNumber = Long.MIN_VALUE;
        this.commitSerialNumber = Long.MIN_VALUE;
        this.recover();
    }

    private void recover() {
        if (!new File(this.pipeLogDir).exists()) {
            return;
        }
        this.recoverPipeLogStartNumber();
        this.recoverLastMaxSerialNumber();
        this.recoverCommitSerialNumber();
        this.recoverOutputDeque();
    }

    private void recoverPipeLogStartNumber() {
        File logDir = new File(this.pipeLogDir);
        ArrayList<Long> startNumbers = new ArrayList<Long>();
        for (File file : logDir.listFiles()) {
            if (!file.getName().endsWith("_pipe.log") || file.length() <= 0L) continue;
            startNumbers.add(SyncPathUtil.getSerialNumberFromPipeLogName((String)file.getName()));
        }
        if (!startNumbers.isEmpty()) {
            Collections.sort(startNumbers);
            for (Long startTime : startNumbers) {
                this.pipeLogStartNumber.offer(startTime);
            }
        }
    }

    private void recoverLastMaxSerialNumber() {
        if (this.pipeLogStartNumber.isEmpty()) {
            return;
        }
        File writingPipeLog = new File(this.pipeLogDir, SyncPathUtil.getPipeLogName((long)((Long)this.pipeLogStartNumber.peekLast())));
        try {
            List<PipeData> recoverPipeData = BufferedPipeDataQueue.parsePipeLog(writingPipeLog);
            int recoverPipeDataSize = recoverPipeData.size();
            this.lastMaxSerialNumber = recoverPipeDataSize == 0 ? (Long)this.pipeLogStartNumber.peekLast() - 1L : recoverPipeData.get(recoverPipeDataSize - 1).getSerialNumber();
        }
        catch (IOException e) {
            logger.error(String.format("Can not recover inputQueue from %s.", writingPipeLog.getPath()), (Throwable)e);
        }
    }

    private void recoverCommitSerialNumber() {
        File commitLog = new File(this.pipeLogDir, "commit.log");
        if (!commitLog.exists()) {
            if (!this.pipeLogStartNumber.isEmpty()) {
                this.commitSerialNumber = this.pipeLogStartNumber.peek() - 1L;
            }
            return;
        }
        try (RandomAccessFile raf = new RandomAccessFile(commitLog, "r");){
            if (raf.length() >= 8L) {
                raf.seek(raf.length() - 8L);
                this.commitSerialNumber = raf.readLong();
            }
        }
        catch (IOException e) {
            logger.error(String.format("deserialize remove serial number error, remove serial number has been set to %d.", this.commitSerialNumber), (Throwable)e);
        }
    }

    private void recoverOutputDeque() {
        if (this.pipeLogStartNumber.isEmpty()) {
            return;
        }
        File readingPipeLog = new File(this.pipeLogDir, SyncPathUtil.getPipeLogName((long)this.pipeLogStartNumber.peek()));
        try {
            PipeData pipeData;
            List<PipeData> recoverPipeData = BufferedPipeDataQueue.parsePipeLog(readingPipeLog);
            int recoverPipeDataSize = recoverPipeData.size();
            for (int i = recoverPipeDataSize - 1; i >= 0 && (pipeData = recoverPipeData.get(i)).getSerialNumber() > this.commitSerialNumber; --i) {
                this.outputDeque.addFirst(pipeData);
            }
        }
        catch (IOException e) {
            logger.error(String.format("Recover output deque from pipe log %s error.", readingPipeLog.getPath()), (Throwable)e);
        }
    }

    public long getLastMaxSerialNumber() {
        return this.lastMaxSerialNumber;
    }

    public long getCommitSerialNumber() {
        return this.commitSerialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(PipeData pipeData) {
        if (this.outputStream == null || this.currentPipeLogSize > SyncConstant.DEFAULT_PIPE_LOG_SIZE_IN_BYTE) {
            try {
                this.moveToNextPipeLog(pipeData.getSerialNumber());
            }
            catch (IOException e) {
                logger.error(String.format("Move to next pipe log %s error.", pipeData), (Throwable)e);
            }
        }
        Object e = this.waitLock;
        synchronized (e) {
            if (!this.inputDeque.offer(pipeData)) {
                this.waitLock.notifyAll();
                return false;
            }
            this.waitLock.notifyAll();
        }
        try {
            this.writeToDisk(pipeData);
        }
        catch (IOException e2) {
            logger.error(String.format("Record pipe data %s error.", pipeData), (Throwable)e2);
            return false;
        }
        return true;
    }

    private synchronized void moveToNextPipeLog(long startSerialNumber) throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        File newPipeLog = new File(this.pipeLogDir, SyncPathUtil.getPipeLogName((long)startSerialNumber));
        SyncPathUtil.createFile((File)newPipeLog);
        this.outputStream = new DataOutputStream(new FileOutputStream(newPipeLog));
        this.pipeLogStartNumber.offer(startSerialNumber);
        this.currentPipeLogSize = 0L;
        this.inputDeque = new LinkedBlockingDeque<PipeData>();
        if (this.commitSerialNumber == Long.MIN_VALUE) {
            this.commitSerialNumber = startSerialNumber - 1L;
        }
    }

    private void writeToDisk(PipeData pipeData) throws IOException {
        this.currentPipeLogSize += pipeData.serialize(this.outputStream);
        this.outputStream.flush();
    }

    private synchronized PipeData pullOnePipeData(long lastSerialNumber) throws IOException {
        long serialNumber = lastSerialNumber + 1L;
        if (!this.outputDeque.isEmpty()) {
            return this.outputDeque.poll();
        }
        if (this.outputDeque != this.inputDeque) {
            if (this.pipeLogStartNumber.isEmpty() || lastSerialNumber == Long.MIN_VALUE) {
                return null;
            }
            if (serialNumber > (Long)this.pipeLogStartNumber.peekLast()) {
                return null;
            }
            if (serialNumber == (Long)this.pipeLogStartNumber.peekLast() && this.inputDeque != null) {
                this.outputDeque = this.inputDeque;
            } else {
                long nextStartNumber = this.pipeLogStartNumber.stream().filter(o -> o >= serialNumber).findFirst().get();
                List<PipeData> parsePipeData = BufferedPipeDataQueue.parsePipeLog(new File(this.pipeLogDir, SyncPathUtil.getPipeLogName((long)nextStartNumber)));
                int parsePipeDataSize = parsePipeData.size();
                this.outputDeque = new LinkedBlockingDeque<PipeData>();
                for (int i = 0; i < parsePipeDataSize; ++i) {
                    this.outputDeque.offer(parsePipeData.get(i));
                }
            }
            return this.outputDeque.poll();
        }
        return null;
    }

    @Override
    public List<PipeData> pull(long serialNumber) {
        throw new NotImplementedException("Not implement pull");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PipeData take() throws InterruptedException {
        PipeData pipeData = null;
        try {
            Object object = this.waitLock;
            synchronized (object) {
                while ((pipeData = this.pullOnePipeData(this.commitSerialNumber)) == null) {
                    this.waitLock.wait();
                    this.waitLock.notifyAll();
                }
            }
        }
        catch (IOException e) {
            logger.error(String.format("Blocking pull pipe data number %s error.", this.commitSerialNumber + 1L), (Throwable)e);
        }
        this.outputDeque.addFirst(pipeData);
        this.pullSerialNumber = pipeData.getSerialNumber();
        return pipeData;
    }

    @Override
    public void commit() {
        if (this.pullSerialNumber == Long.MIN_VALUE) {
            return;
        }
        this.commit(this.pullSerialNumber);
    }

    @Override
    public void commit(long serialNumber) {
        this.deletePipeData(serialNumber);
        this.deletePipeLog();
        this.serializeCommitSerialNumber();
    }

    private void deletePipeData(long serialNumber) {
        while (this.commitSerialNumber < serialNumber) {
            PipeData commitData = null;
            try {
                commitData = this.pullOnePipeData(this.commitSerialNumber);
                if (commitData == null) {
                    return;
                }
                if (PipeData.PipeDataType.TSFILE.equals((Object)commitData.getPipeDataType())) {
                    List<File> tsFiles = ((TsFilePipeData)commitData).getTsFiles(false);
                    for (File file : tsFiles) {
                        Files.deleteIfExists(file.toPath());
                    }
                }
            }
            catch (IOException e) {
                logger.error(String.format("Commit pipe data serial number %s error.", this.commitSerialNumber), (Throwable)e);
            }
            if (commitData == null) continue;
            this.commitSerialNumber = commitData.getSerialNumber();
        }
    }

    private void deletePipeLog() {
        if (this.pipeLogStartNumber.size() >= 2) {
            long nowPipeLogStartNumber;
            while (true) {
                nowPipeLogStartNumber = this.pipeLogStartNumber.poll();
                if (this.pipeLogStartNumber.isEmpty() || this.pipeLogStartNumber.peek() > this.commitSerialNumber) break;
                try {
                    Files.deleteIfExists(new File(this.pipeLogDir, SyncPathUtil.getPipeLogName((long)nowPipeLogStartNumber)).toPath());
                }
                catch (IOException e) {
                    logger.warn(String.format("Delete %s-pipe.log error.", nowPipeLogStartNumber), (Throwable)e);
                }
            }
            this.pipeLogStartNumber.addFirst(nowPipeLogStartNumber);
        }
    }

    private void serializeCommitSerialNumber() {
        try {
            if (this.commitLogWriter == null) {
                this.commitLogWriter = new DataOutputStream(new FileOutputStream(new File(this.pipeLogDir, "commit.log")));
                this.currentCommitLogSize = 0L;
            }
            this.commitLogWriter.writeLong(this.commitSerialNumber);
            this.commitLogWriter.flush();
            this.currentCommitLogSize += 8L;
            if (this.currentCommitLogSize >= SyncConstant.DEFAULT_PIPE_LOG_SIZE_IN_BYTE) {
                this.commitLogWriter.close();
                this.commitLogWriter = null;
            }
        }
        catch (IOException e) {
            logger.error(String.format("Serialize commit serial number %s error.", this.commitSerialNumber), (Throwable)e);
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.outputDeque == null || this.pipeLogStartNumber.isEmpty()) {
            return true;
        }
        return this.pipeLogStartNumber.size() == 1 && this.outputDeque.isEmpty() && (this.inputDeque == null || this.inputDeque.isEmpty());
    }

    @Override
    public void close() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.commitLogWriter != null) {
                this.commitLogWriter.close();
                this.commitLogWriter = null;
            }
            this.inputDeque = null;
            this.pipeLogStartNumber = null;
            this.outputDeque = null;
        }
        catch (IOException e) {
            logger.warn(String.format("Close pipe log dir %s error.", this.pipeLogDir), (Throwable)e);
        }
    }

    @Override
    public void clear() {
        this.close();
        File logDir = new File(this.pipeLogDir);
        if (logDir.exists()) {
            FileUtils.deleteDirectory((File)logDir);
        }
    }

    public static List<PipeData> parsePipeLog(File file) throws IOException {
        ArrayList<PipeData> pipeData = new ArrayList<PipeData>();
        try {
            DataInputStream inputStream = new DataInputStream(new FileInputStream(file));
            try {
                while (true) {
                    pipeData.add(PipeData.createPipeData(inputStream));
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException inputStream) {
        }
        catch (IllegalPathException e) {
            logger.error(String.format("Parsing pipeLog %s error.", file.getPath()), (Throwable)e);
            throw new IOException(e);
        }
        return pipeData;
    }
}

