/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.pipedata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.sync.utils.SyncConstant;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.pipedata.load.ILoader;
import org.apache.iotdb.db.sync.pipedata.load.TsFileLoader;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFilePipeData
extends PipeData {
    private static final Logger logger = LoggerFactory.getLogger(TsFilePipeData.class);
    private String parentDirPath;
    private String tsFileName;
    private String database;

    public TsFilePipeData() {
    }

    public TsFilePipeData(String tsFilePath, long serialNumber) {
        super(serialNumber);
        String sep = File.separator.equals("\\") ? "\\\\" : File.separator;
        String[] paths = tsFilePath.split(sep);
        this.tsFileName = paths[paths.length - 1];
        this.parentDirPath = paths.length > 1 ? tsFilePath.substring(0, tsFilePath.length() - this.tsFileName.length() - File.separator.length()) : "";
        this.initDatabaseName();
    }

    public TsFilePipeData(String parentDirPath, String tsFileName, long serialNumber) {
        super(serialNumber);
        this.parentDirPath = parentDirPath;
        this.tsFileName = tsFileName;
        this.initDatabaseName();
    }

    private void initDatabaseName() {
        if (this.tsFileName == null) {
            this.database = null;
            return;
        }
        String[] parts = this.tsFileName.trim().split("-");
        if (parts.length < 8) {
            this.database = null;
            return;
        }
        this.database = parts[1];
        for (int i = 2; i < parts.length - 6; ++i) {
            this.database = this.database + "-" + parts[i];
        }
    }

    public void setParentDirPath(String parentDirPath) {
        this.parentDirPath = parentDirPath;
    }

    public String getTsFileName() {
        return this.tsFileName;
    }

    public String getTsFilePath() {
        return this.parentDirPath + File.separator + this.tsFileName;
    }

    public String getResourceFilePath() {
        return this.getTsFilePath() + ".resource";
    }

    public String getModsFilePath() {
        return this.getTsFilePath() + ".mods";
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    @Override
    public PipeData.PipeDataType getPipeDataType() {
        return PipeData.PipeDataType.TSFILE;
    }

    @Override
    public long serialize(DataOutputStream stream) throws IOException {
        return super.serialize(stream) + (long)ReadWriteIOUtils.write((String)this.parentDirPath, (OutputStream)stream) + (long)ReadWriteIOUtils.write((String)this.tsFileName, (OutputStream)stream);
    }

    @Override
    public void deserialize(DataInputStream stream) throws IOException, IllegalPathException {
        super.deserialize(stream);
        this.parentDirPath = ReadWriteIOUtils.readString((InputStream)stream);
        if (this.parentDirPath == null) {
            this.parentDirPath = "";
        }
        this.tsFileName = ReadWriteIOUtils.readString((InputStream)stream);
        this.initDatabaseName();
    }

    @Override
    public ILoader createLoader() {
        return new TsFileLoader(new File(this.getTsFilePath()), this.database);
    }

    public List<File> getTsFiles(boolean shouldWaitForTsFileClose) throws FileNotFoundException {
        File tsFile = new File(this.getTsFilePath()).getAbsoluteFile();
        File resource = new File(this.getResourceFilePath());
        File mods = new File(this.getModsFilePath());
        ArrayList<File> files = new ArrayList<File>();
        if (!tsFile.exists()) {
            throw new FileNotFoundException(String.format("Can not find %s.", tsFile.getAbsolutePath()));
        }
        files.add(tsFile);
        if (resource.exists()) {
            files.add(resource);
        } else if (shouldWaitForTsFileClose && !this.waitForTsFileClose()) {
            throw new FileNotFoundException(String.format("Can not find %s, maybe the tsfile is not closed yet", resource.getAbsolutePath()));
        }
        if (mods.exists()) {
            files.add(mods);
        }
        return files;
    }

    private boolean waitForTsFileClose() {
        int i = 0;
        while ((long)i < SyncConstant.DEFAULT_WAITING_FOR_TSFILE_RETRY_NUMBER) {
            if (this.isTsFileClosed()) {
                return true;
            }
            try {
                Thread.sleep(SyncConstant.DEFAULT_WAITING_FOR_TSFILE_CLOSE_MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.warn(String.format("Be Interrupted when waiting for tsfile %s closed", this.tsFileName));
            }
            logger.info(String.format("Waiting for tsfile %s close, retry %d / %d.", this.tsFileName, i + 1, SyncConstant.DEFAULT_WAITING_FOR_TSFILE_RETRY_NUMBER));
            ++i;
        }
        return false;
    }

    private boolean isTsFileClosed() {
        File tsFile = new File(this.getTsFilePath()).getAbsoluteFile();
        File resource = new File(tsFile.getAbsolutePath() + ".resource");
        return resource.exists();
    }

    public String toString() {
        return "TsFilePipeData{serialNumber=" + this.serialNumber + ", tsFilePath='" + this.getTsFilePath() + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFilePipeData pipeData = (TsFilePipeData)o;
        return Objects.equals(this.parentDirPath, pipeData.parentDirPath) && Objects.equals(this.tsFileName, pipeData.tsFileName) && Objects.equals(this.serialNumber, pipeData.serialNumber);
    }

    public int hashCode() {
        return Objects.hash(this.parentDirPath, this.tsFileName, this.serialNumber);
    }
}

