/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.externalpipe;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.pipe.external.api.IExternalPipeSinkWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtPipePluginRegister {
    private static final Logger logger = LoggerFactory.getLogger(ExtPipePluginRegister.class);
    private final String extPipeDir;
    private final Map<String, IExternalPipeSinkWriterFactory> writerFactoryMap = new ConcurrentHashMap<String, IExternalPipeSinkWriterFactory>();

    private ExtPipePluginRegister() throws IOException {
        this.extPipeDir = IoTDBDescriptor.getInstance().getConfig().getExtPipeDir();
        logger.info("extPipeDir: {}", (Object)this.extPipeDir);
        this.makeExtPipeDir();
        this.buildFactoryMap();
    }

    public boolean pluginExist(String pluginName) {
        return this.writerFactoryMap.containsKey(pluginName.toLowerCase());
    }

    public IExternalPipeSinkWriterFactory getWriteFactory(String pluginName) {
        return this.writerFactoryMap.get(pluginName.toLowerCase());
    }

    public Set<String> getAllPluginName() {
        return this.writerFactoryMap.keySet();
    }

    private void makeExtPipeDir() throws IOException {
        File file = SystemFileFactory.INSTANCE.getFile(this.extPipeDir);
        if (file.exists() && file.isDirectory()) {
            return;
        }
        FileUtils.forceMkdir((File)file);
    }

    private Collection<File> findAllJar(File directory) {
        Collection collection;
        block8: {
            Stream stream = FileUtils.streamFiles((File)directory, (boolean)true, (String[])new String[]{"jar"});
            try {
                collection = stream.collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(directory.toString(), e);
                }
            }
            stream.close();
        }
        return collection;
    }

    private URL[] getPlugInJarURLs() throws IOException {
        HashSet<File> fileSet = new HashSet<File>(this.findAllJar(SystemFileFactory.INSTANCE.getFile(this.extPipeDir)));
        return FileUtils.toURLs((File[])fileSet.toArray(new File[0]));
    }

    private void buildFactoryMap() throws IOException {
        Object[] jarURLs = this.getPlugInJarURLs();
        logger.debug("ExtPipePluginRegister buildFactoryMap(), ExtPIPE Plugin jarURLs: {}", jarURLs);
        for (Object jarUrl : jarURLs) {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{jarUrl});
            ServiceLoader<IExternalPipeSinkWriterFactory> factories = ServiceLoader.load(IExternalPipeSinkWriterFactory.class, classLoader);
            for (IExternalPipeSinkWriterFactory factory : factories) {
                if (factory == null) {
                    logger.error("ExtPipePluginRegister buildFactoryMap(), factory is null.");
                    continue;
                }
                String pluginName = factory.getExternalPipeType().toLowerCase();
                this.writerFactoryMap.put(pluginName, factory);
                logger.info("ExtPipePluginRegister buildFactoryMap(), find ExternalPipe Plugin {}.", (Object)pluginName);
            }
        }
    }

    public static ExtPipePluginRegister getInstance() {
        return ExtPipePluginRegisterHolder.INSTANCE;
    }

    private static class ExtPipePluginRegisterHolder {
        private static ExtPipePluginRegister INSTANCE = null;

        private ExtPipePluginRegisterHolder() {
        }

        static {
            try {
                INSTANCE = new ExtPipePluginRegister();
            }
            catch (IOException e) {
                logger.error("new ExtPipePluginRegister() error.", (Throwable)e);
            }
        }
    }
}

