/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.mpp.metric.QueryMetricsManager;
import org.apache.iotdb.db.query.reader.chunk.MemChunkReader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;

public class MemChunkLoader
implements IChunkLoader {
    private final ReadOnlyMemChunk chunk;
    private static final QueryMetricsManager QUERY_METRICS = QueryMetricsManager.getInstance();

    public MemChunkLoader(ReadOnlyMemChunk chunk) {
        this.chunk = chunk;
    }

    public Chunk loadChunk(ChunkMetadata chunkMetaData) {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter timeFilter) {
        long startTime = System.nanoTime();
        try {
            MemChunkReader memChunkReader = new MemChunkReader(this.chunk, timeFilter);
            return memChunkReader;
        }
        finally {
            long duration = System.nanoTime() - startTime;
            QUERY_METRICS.recordSeriesScanCost("construct_chunk_reader_nonaligned_mem", duration);
            QUERY_METRICS.recordSeriesScanCost("init_chunk_reader_nonaligned_mem", duration);
        }
    }
}

