/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import java.io.IOException;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.mpp.metric.QueryMetricsManager;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;

public class DiskChunkLoader
implements IChunkLoader {
    private final boolean debug;
    private static final QueryMetricsManager QUERY_METRICS = QueryMetricsManager.getInstance();

    public DiskChunkLoader(boolean debug) {
        this.debug = debug;
    }

    public Chunk loadChunk(ChunkMetadata chunkMetaData) throws IOException {
        return ChunkCache.getInstance().get(chunkMetaData, this.debug);
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter timeFilter) throws IOException {
        long t1 = System.nanoTime();
        try {
            Chunk chunk = ChunkCache.getInstance().get((ChunkMetadata)chunkMetaData, this.debug);
            chunk.setFromOldFile(chunkMetaData.isFromOldTsFile());
            long t2 = System.nanoTime();
            ChunkReader chunkReader = new ChunkReader(chunk, timeFilter);
            QUERY_METRICS.recordSeriesScanCost("init_chunk_reader_nonaligned_disk", System.nanoTime() - t2);
            ChunkReader chunkReader2 = chunkReader;
            return chunkReader2;
        }
        finally {
            QUERY_METRICS.recordSeriesScanCost("construct_chunk_reader_nonaligned_disk", System.nanoTime() - t1);
        }
    }
}

