/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.statement;

import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.mpp.plan.statement.component.SelectComponent;
import org.apache.iotdb.db.protocol.influxdb.constant.InfluxSqlConstant;

public final class InfluxSelectComponent
extends SelectComponent {
    private boolean hasAggregationFunction = false;
    private boolean hasSelectorFunction = false;
    private boolean hasMoreSelectorFunction = false;
    private boolean hasMoreFunction = false;
    private boolean hasFunction = false;
    private boolean hasCommonQuery = false;
    private boolean hasOnlyTraverseFunction = false;

    public InfluxSelectComponent() {
        super(null);
    }

    @Override
    public void addResultColumn(ResultColumn resultColumn) {
        Expression expression = resultColumn.getExpression();
        if (expression instanceof FunctionExpression) {
            String functionName = ((FunctionExpression)expression).getFunctionName();
            if (InfluxSqlConstant.getNativeFunctionNames().contains(functionName.toLowerCase())) {
                if (this.hasFunction) {
                    this.hasMoreFunction = true;
                } else {
                    this.hasFunction = true;
                }
            }
            if (InfluxSqlConstant.getNativeSelectorFunctionNames().contains(functionName.toLowerCase())) {
                if (this.hasSelectorFunction) {
                    this.hasMoreSelectorFunction = true;
                } else {
                    this.hasSelectorFunction = true;
                }
            } else {
                this.hasAggregationFunction = true;
            }
            if (InfluxSqlConstant.getOnlyTraverseFunctionNames().contains(functionName.toLowerCase())) {
                this.hasOnlyTraverseFunction = true;
            }
        }
        if (expression instanceof TimeSeriesOperand) {
            this.hasCommonQuery = true;
        }
        this.resultColumns.add(resultColumn);
    }

    public boolean isHasAggregationFunction() {
        return this.hasAggregationFunction;
    }

    public boolean isHasMoreFunction() {
        return this.hasMoreFunction;
    }

    public boolean isHasCommonQuery() {
        return this.hasCommonQuery;
    }

    public boolean isHasOnlyTraverseFunction() {
        return this.hasOnlyTraverseFunction;
    }

    public boolean isHasMoreSelectorFunction() {
        return this.hasMoreSelectorFunction;
    }

    public boolean isHasFunction() {
        return this.hasFunction;
    }
}

