/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.mpp.common.NodeRef;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.IntermediateLayerVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.input.QueryDataSetInputLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFContext;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class EvaluationDAGBuilder {
    private final String queryId;
    private final QueryDataSetInputLayer inputLayer;
    private final Map<String, List<InputLocation>> inputLocations;
    private final Expression[] outputExpressions;
    private final LayerPointReader[] outputPointReaders;
    private final Map<NodeRef<Expression>, TSDataType> expressionTypes;
    private final UDTFContext udtfContext;
    private final LayerMemoryAssigner memoryAssigner;
    private final Map<Expression, IntermediateLayer> expressionIntermediateLayerMap;

    public EvaluationDAGBuilder(String queryId, QueryDataSetInputLayer inputLayer, Map<String, List<InputLocation>> inputLocations, Expression[] outputExpressions, Map<NodeRef<Expression>, TSDataType> expressionTypes, UDTFContext udtfContext, float memoryBudgetInMB) {
        this.queryId = queryId;
        this.inputLayer = inputLayer;
        this.inputLocations = inputLocations;
        this.outputExpressions = outputExpressions;
        this.expressionTypes = expressionTypes;
        this.udtfContext = udtfContext;
        this.outputPointReaders = new LayerPointReader[outputExpressions.length];
        this.memoryAssigner = new LayerMemoryAssigner(memoryBudgetInMB);
        this.expressionIntermediateLayerMap = new HashMap<Expression, IntermediateLayer>();
    }

    public EvaluationDAGBuilder buildLayerMemoryAssigner() {
        for (Expression expression : this.outputExpressions) {
            expression.updateStatisticsForMemoryAssigner(this.memoryAssigner);
        }
        this.memoryAssigner.build();
        return this;
    }

    public EvaluationDAGBuilder bindInputLayerColumnIndexWithExpression() {
        for (Expression expression : this.outputExpressions) {
            expression.bindInputLayerColumnIndexWithExpression(this.inputLocations);
        }
        return this;
    }

    public EvaluationDAGBuilder buildResultColumnPointReaders() {
        IntermediateLayerVisitor visitor = new IntermediateLayerVisitor();
        IntermediateLayerVisitor.IntermediateLayerVisitorContext context = new IntermediateLayerVisitor.IntermediateLayerVisitorContext(this.queryId, this.udtfContext, this.inputLayer, this.expressionIntermediateLayerMap, this.expressionTypes, this.memoryAssigner);
        for (int i = 0; i < this.outputExpressions.length; ++i) {
            this.outputPointReaders[i] = ((IntermediateLayer)visitor.process(this.outputExpressions[i], context)).constructPointReader();
        }
        return this;
    }

    public LayerPointReader[] getOutputPointReaders() {
        return this.outputPointReaders;
    }
}

