/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.statement.IConfigStatement;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;

public class SetTTLStatement
extends Statement
implements IConfigStatement {
    protected PartialPath storageGroupPath;
    protected long ttl;

    public SetTTLStatement() {
        this.statementType = StatementType.TTL;
    }

    public PartialPath getStorageGroupPath() {
        return this.storageGroupPath;
    }

    public long getTTL() {
        return this.ttl;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitSetTTL(this, context);
    }

    public void setStorageGroupPath(PartialPath storageGroupPath) {
        this.storageGroupPath = storageGroupPath;
    }

    public void setTTL(long ttl) {
        this.ttl = ttl;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    public List<PartialPath> getPaths() {
        return this.storageGroupPath != null ? Collections.singletonList(this.storageGroupPath) : Collections.emptyList();
    }
}

