/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.statement.IConfigStatement;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;

public class GetRegionIdStatement
extends Statement
implements IConfigStatement {
    private final String storageGroup;
    private String deviceId;
    private TSeriesPartitionSlot seriesSlotId;
    private final TConsensusGroupType partitionType;
    private TTimePartitionSlot timeSlotId;
    private long timeStamp = -1L;

    public GetRegionIdStatement(String storageGroup, TConsensusGroupType partitionType) {
        this.storageGroup = storageGroup;
        this.partitionType = partitionType;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public TConsensusGroupType getPartitionType() {
        return this.partitionType;
    }

    public TSeriesPartitionSlot getSeriesSlotId() {
        return this.seriesSlotId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public TTimePartitionSlot getTimeSlotId() {
        return this.timeSlotId;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeSlotId(TTimePartitionSlot timeSlotId) {
        this.timeSlotId = timeSlotId;
    }

    public void setSeriesSlotId(TSeriesPartitionSlot seriesSlotId) {
        this.seriesSlotId = seriesSlotId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitGetRegionId(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.READ;
    }

    public List<PartialPath> getPaths() {
        try {
            return Collections.singletonList(new PartialPath(this.storageGroup));
        }
        catch (IllegalPathException e) {
            return new ArrayList<PartialPath>();
        }
    }
}

