/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.crud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.statement.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.utils.TimePartitionUtils;
import org.apache.iotdb.tsfile.utils.BitMap;

public class InsertTabletStatement
extends InsertBaseStatement {
    private long[] times;
    private BitMap[] bitMaps;
    private Object[] columns;
    private int rowCount = 0;

    public InsertTabletStatement() {
        this.statementType = StatementType.BATCH_INSERT;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public Object[] getColumns() {
        return this.columns;
    }

    public void setColumns(Object[] columns) {
        this.columns = columns;
    }

    public BitMap[] getBitMaps() {
        return this.bitMaps;
    }

    public void setBitMaps(BitMap[] bitMaps) {
        this.bitMaps = bitMaps;
    }

    public long[] getTimes() {
        return this.times;
    }

    public void setTimes(long[] times) {
        this.times = times;
    }

    @Override
    public boolean isEmpty() {
        return this.rowCount == 0 || this.times.length == 0 || this.measurements.length == 0 || this.dataTypes.length == 0 || this.columns.length == 0;
    }

    public List<TTimePartitionSlot> getTimePartitionSlots() {
        ArrayList<TTimePartitionSlot> result = new ArrayList<TTimePartitionSlot>();
        long startTime = this.times[0] / TimePartitionUtils.timePartitionInterval * TimePartitionUtils.timePartitionInterval;
        long endTime = startTime + TimePartitionUtils.timePartitionInterval;
        TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartition(this.times[0]);
        for (int i = 1; i < this.times.length; ++i) {
            if (this.times[i] < endTime) continue;
            result.add(timePartitionSlot);
            endTime = (this.times[i] / TimePartitionUtils.timePartitionInterval + 1L) * TimePartitionUtils.timePartitionInterval;
            timePartitionSlot = TimePartitionUtils.getTimePartition(this.times[i]);
        }
        result.add(timePartitionSlot);
        return result;
    }

    @Override
    public List<TEndPoint> collectRedirectInfo(DataPartition dataPartition) {
        TRegionReplicaSet regionReplicaSet = dataPartition.getDataRegionReplicaSetForWriting(this.devicePath.getFullPath(), TimePartitionUtils.getTimePartition(this.times[this.times.length - 1]));
        return Collections.singletonList(((TDataNodeLocation)regionReplicaSet.getDataNodeLocations().get(0)).getClientRpcEndPoint());
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInsertTablet(this, context);
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String m : this.measurements) {
            PartialPath fullPath = this.devicePath.concatNode(m);
            ret.add(fullPath);
        }
        return ret;
    }
}

