/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process.last;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LastQueryNode
extends MultiChildProcessNode {
    private final Filter timeFilter;
    private OrderByParameter mergeOrderParameter;

    public LastQueryNode(PlanNodeId id, Filter timeFilter, OrderByParameter mergeOrderParameter) {
        super(id);
        this.timeFilter = timeFilter;
        this.mergeOrderParameter = mergeOrderParameter;
    }

    public LastQueryNode(PlanNodeId id, List<PlanNode> children, Filter timeFilter, OrderByParameter mergeOrderParameter) {
        super(id, children);
        this.timeFilter = timeFilter;
        this.mergeOrderParameter = mergeOrderParameter;
    }

    @Override
    public List<PlanNode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(PlanNode child) {
        this.children.add(child);
    }

    @Override
    public PlanNode clone() {
        return new LastQueryNode(this.getPlanNodeId(), this.timeFilter, this.mergeOrderParameter);
    }

    @Override
    public int allowedChildCount() {
        return -1;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return LastQueryScanNode.LAST_QUERY_HEADER_COLUMNS;
    }

    public String toString() {
        return String.format("LastQueryNode-%s:[TimeFilter: %s]", this.getPlanNodeId(), this.timeFilter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LastQueryNode that = (LastQueryNode)o;
        return Objects.equals(this.timeFilter, that.timeFilter) && this.mergeOrderParameter.equals(that.mergeOrderParameter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.timeFilter, this.mergeOrderParameter);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLastQuery(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LAST_QUERY.serialize(byteBuffer);
        if (this.timeFilter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.timeFilter.serialize(byteBuffer);
        }
        this.mergeOrderParameter.serializeAttributes(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LAST_QUERY.serialize(stream);
        if (this.timeFilter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.timeFilter.serialize(stream);
        }
        this.mergeOrderParameter.serializeAttributes(stream);
    }

    public static LastQueryNode deserialize(ByteBuffer byteBuffer) {
        Filter timeFilter = null;
        if (ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1) {
            timeFilter = FilterFactory.deserialize((ByteBuffer)byteBuffer);
        }
        OrderByParameter mergeOrderParameter = OrderByParameter.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LastQueryNode(planNodeId, timeFilter, mergeOrderParameter);
    }

    @Override
    public void setChildren(List<PlanNode> children) {
        this.children = children;
    }

    @Nullable
    public Filter getTimeFilter() {
        return this.timeFilter;
    }

    public OrderByParameter getMergeOrderParameter() {
        return this.mergeOrderParameter;
    }

    public void setMergeOrderParameter(OrderByParameter mergeOrderParameter) {
        this.mergeOrderParameter = mergeOrderParameter;
    }
}

