/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class MeasurementGroup {
    private List<String> measurements = new ArrayList<String>();
    private List<TSDataType> dataTypes = new ArrayList<TSDataType>();
    private List<TSEncoding> encodings = new ArrayList<TSEncoding>();
    private List<CompressionType> compressors = new ArrayList<CompressionType>();
    private List<String> aliasList;
    private List<Map<String, String>> propsList;
    private List<Map<String, String>> tagsList;
    private List<Map<String, String>> attributesList;
    private final transient Set<String> measurementSet = new HashSet<String>();

    public List<String> getMeasurements() {
        return this.measurements;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public List<TSEncoding> getEncodings() {
        return this.encodings;
    }

    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    public List<String> getAliasList() {
        return this.aliasList;
    }

    public List<Map<String, String>> getPropsList() {
        return this.propsList;
    }

    public List<Map<String, String>> getTagsList() {
        return this.tagsList;
    }

    public void setTagsList(List<Map<String, String>> tagsList) {
        this.tagsList = tagsList;
    }

    public List<Map<String, String>> getAttributesList() {
        return this.attributesList;
    }

    public boolean addMeasurement(String measurement, TSDataType dataType, TSEncoding encoding, CompressionType compressionType) {
        if (this.measurementSet.contains(measurement)) {
            return false;
        }
        this.measurements.add(measurement);
        this.measurementSet.add(measurement);
        this.dataTypes.add(dataType);
        this.encodings.add(encoding);
        this.compressors.add(compressionType);
        return true;
    }

    public void addAlias(String alias) {
        if (this.aliasList == null) {
            this.aliasList = new ArrayList<String>();
        }
        this.aliasList.add(alias);
    }

    public void addProps(Map<String, String> props) {
        if (this.propsList == null) {
            this.propsList = new ArrayList<Map<String, String>>();
        }
        this.propsList.add(props);
    }

    public void addTags(Map<String, String> tags) {
        if (this.tagsList == null) {
            this.tagsList = new ArrayList<Map<String, String>>();
        }
        this.tagsList.add(tags);
    }

    public void addAttributes(Map<String, String> attributes) {
        if (this.attributesList == null) {
            this.attributesList = new ArrayList<Map<String, String>>();
        }
        this.attributesList.add(attributes);
    }

    public void removeMeasurements(Set<Integer> indexSet) {
        int restSize = this.measurements.size() - indexSet.size();
        ArrayList<String> measurements = new ArrayList<String>(restSize);
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>(restSize);
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>(restSize);
        ArrayList<CompressionType> compressors = new ArrayList<CompressionType>(restSize);
        ArrayList<String> aliasList = this.aliasList == null ? null : new ArrayList<String>(restSize);
        ArrayList<Map<String, String>> propsList = this.propsList == null ? null : new ArrayList<Map<String, String>>(restSize);
        ArrayList<Map<String, String>> tagsList = this.tagsList == null ? null : new ArrayList<Map<String, String>>(restSize);
        ArrayList<Map<String, String>> attributesList = this.attributesList == null ? null : new ArrayList<Map<String, String>>(restSize);
        for (int i = 0; i < this.measurements.size(); ++i) {
            if (indexSet.contains(i)) {
                this.measurementSet.remove(this.measurements.get(i));
                continue;
            }
            measurements.add(this.measurements.get(i));
            dataTypes.add(this.dataTypes.get(i));
            encodings.add(this.encodings.get(i));
            compressors.add(this.compressors.get(i));
            if (aliasList != null) {
                aliasList.add(this.aliasList.get(i));
            }
            if (propsList != null) {
                propsList.add(this.propsList.get(i));
            }
            if (tagsList != null) {
                tagsList.add(this.tagsList.get(i));
            }
            if (attributesList == null) continue;
            attributesList.add(this.attributesList.get(i));
        }
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.encodings = encodings;
        this.compressors = compressors;
        this.aliasList = aliasList;
        this.propsList = propsList;
        this.tagsList = tagsList;
        this.attributesList = attributesList;
    }

    public int size() {
        return this.measurements.size();
    }

    public boolean isEmpty() {
        return this.measurements.isEmpty();
    }

    public List<MeasurementGroup> split(int targetSize) {
        int totalSize = this.measurements.size();
        int fullGroupNum = totalSize / targetSize;
        int restSize = totalSize % targetSize;
        ArrayList<MeasurementGroup> result = new ArrayList<MeasurementGroup>(fullGroupNum + (restSize == 0 ? 0 : 1));
        if (totalSize <= targetSize) {
            result.add(this);
            return result;
        }
        for (int i = 0; i < fullGroupNum; ++i) {
            result.add(this.getSubMeasurementGroup(i * targetSize, i * targetSize + targetSize));
        }
        if (restSize != 0) {
            result.add(this.getSubMeasurementGroup(totalSize - restSize, totalSize));
        }
        return result;
    }

    private MeasurementGroup getSubMeasurementGroup(int startIndex, int endIndex) {
        MeasurementGroup subMeasurementGroup = new MeasurementGroup();
        subMeasurementGroup.measurements = this.measurements.subList(startIndex, endIndex);
        subMeasurementGroup.measurementSet.addAll(subMeasurementGroup.measurements);
        subMeasurementGroup.dataTypes = this.dataTypes.subList(startIndex, endIndex);
        subMeasurementGroup.encodings = this.encodings.subList(startIndex, endIndex);
        subMeasurementGroup.compressors = this.compressors.subList(startIndex, endIndex);
        if (this.aliasList != null) {
            subMeasurementGroup.aliasList = this.aliasList.subList(startIndex, endIndex);
        }
        if (this.propsList != null) {
            subMeasurementGroup.propsList = this.propsList.subList(startIndex, endIndex);
        }
        if (this.tagsList != null) {
            subMeasurementGroup.tagsList = this.tagsList.subList(startIndex, endIndex);
        }
        if (this.attributesList != null) {
            subMeasurementGroup.attributesList = this.attributesList.subList(startIndex, endIndex);
        }
        return subMeasurementGroup;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.measurements.size(), (ByteBuffer)byteBuffer);
        for (String string : this.measurements) {
            ReadWriteIOUtils.write((String)string, (ByteBuffer)byteBuffer);
        }
        for (TSDataType tSDataType : this.dataTypes) {
            byteBuffer.put((byte)tSDataType.ordinal());
        }
        for (TSEncoding tSEncoding : this.encodings) {
            byteBuffer.put((byte)tSEncoding.ordinal());
        }
        for (CompressionType compressionType : this.compressors) {
            byteBuffer.put(compressionType.serialize());
        }
        if (this.aliasList == null) {
            byteBuffer.put((byte)-1);
        } else if (this.aliasList.isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            for (String string : this.aliasList) {
                ReadWriteIOUtils.write((String)string, (ByteBuffer)byteBuffer);
            }
        }
        if (this.tagsList == null) {
            byteBuffer.put((byte)-1);
        } else if (this.tagsList.isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            for (Map map : this.tagsList) {
                ReadWriteIOUtils.write((Map)map, (ByteBuffer)byteBuffer);
            }
        }
        if (this.attributesList == null) {
            byteBuffer.put((byte)-1);
        } else if (this.attributesList.isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            for (Map map : this.attributesList) {
                ReadWriteIOUtils.write((Map)map, (ByteBuffer)byteBuffer);
            }
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.measurements.size(), (OutputStream)stream);
        for (String string : this.measurements) {
            ReadWriteIOUtils.write((String)string, (OutputStream)stream);
        }
        for (TSDataType tSDataType : this.dataTypes) {
            stream.write((byte)tSDataType.ordinal());
        }
        for (TSEncoding tSEncoding : this.encodings) {
            stream.write((byte)tSEncoding.ordinal());
        }
        for (CompressionType compressionType : this.compressors) {
            stream.write(compressionType.serialize());
        }
        if (this.aliasList == null) {
            stream.write(-1);
        } else if (this.aliasList.isEmpty()) {
            stream.write(0);
        } else {
            stream.write(1);
            for (String string : this.aliasList) {
                ReadWriteIOUtils.write((String)string, (OutputStream)stream);
            }
        }
        if (this.tagsList == null) {
            stream.write(-1);
        } else if (this.tagsList.isEmpty()) {
            stream.write(0);
        } else {
            stream.write(1);
            for (Map map : this.tagsList) {
                ReadWriteIOUtils.write((Map)map, (OutputStream)stream);
            }
        }
        if (this.attributesList == null) {
            stream.write(-1);
        } else if (this.attributesList.isEmpty()) {
            stream.write(0);
        } else {
            stream.write(1);
            for (Map map : this.attributesList) {
                ReadWriteIOUtils.write((Map)map, (OutputStream)stream);
            }
        }
    }

    public void deserialize(ByteBuffer byteBuffer) {
        int i;
        int i2;
        this.measurements = new ArrayList<String>();
        int size = byteBuffer.getInt();
        for (i2 = 0; i2 < size; ++i2) {
            this.measurements.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        this.measurementSet.addAll(this.measurements);
        this.dataTypes = new ArrayList<TSDataType>();
        for (i2 = 0; i2 < size; ++i2) {
            this.dataTypes.add(TSDataType.values()[byteBuffer.get()]);
        }
        this.encodings = new ArrayList<TSEncoding>();
        for (i2 = 0; i2 < size; ++i2) {
            this.encodings.add(TSEncoding.values()[byteBuffer.get()]);
        }
        this.compressors = new ArrayList<CompressionType>();
        for (i2 = 0; i2 < size; ++i2) {
            this.compressors.add(CompressionType.deserialize((byte)byteBuffer.get()));
        }
        byte label = byteBuffer.get();
        if (label >= 0) {
            this.aliasList = new ArrayList<String>();
            if (label == 1) {
                for (i = 0; i < size; ++i) {
                    this.aliasList.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
                }
            }
        }
        if ((label = byteBuffer.get()) >= 0) {
            this.tagsList = new ArrayList<Map<String, String>>();
            if (label == 1) {
                for (i = 0; i < size; ++i) {
                    this.tagsList.add(ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer));
                }
            }
        }
        if ((label = byteBuffer.get()) >= 0) {
            this.attributesList = new ArrayList<Map<String, String>>();
            if (label == 1) {
                for (i = 0; i < size; ++i) {
                    this.attributesList.add(ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer));
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasurementGroup that = (MeasurementGroup)o;
        return Objects.equals(this.measurements, that.measurements) && Objects.equals(this.dataTypes, that.dataTypes) && Objects.equals(this.encodings, that.encodings) && Objects.equals(this.compressors, that.compressors) && Objects.equals(this.aliasList, that.aliasList) && Objects.equals(this.propsList, that.propsList) && Objects.equals(this.tagsList, that.tagsList) && Objects.equals(this.attributesList, that.attributesList);
    }

    public int hashCode() {
        return Objects.hash(this.measurements, this.dataTypes, this.encodings, this.compressors, this.aliasList, this.propsList, this.tagsList, this.attributesList);
    }
}

